package vazkii.patchouli.client.book.page.abstr;

import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class PageDoubleRecipeRegistry<T extends class_1860<?>> extends PageDoubleRecipe<T> {
	private final class_3956<? extends T> recipeType;

	public PageDoubleRecipeRegistry(class_3956<? extends T> recipeType) {
		this.recipeType = recipeType;
	}

	@Nullable
	private T getRecipe(class_1937 level, class_2960 id) {
		class_1863 manager = level.method_8433();
		return (T) manager.method_8130(id).filter(recipe -> recipe.method_17716() == recipeType).orElse(null);
	}

	@Override
	protected T loadRecipe(class_1937 level, BookContentsBuilder builder, BookEntry entry, class_2960 res) {
		if (res == null || level == null) {
			return null;
		}

		T tempRecipe = getRecipe(level, res);
		if (tempRecipe == null) { // this is hacky but it works around Forge requiring custom recipes to have the prefix of the adding mod
			tempRecipe = getRecipe(level, new class_2960("crafttweaker", res.method_12832()));
		}

		if (tempRecipe != null) {
			entry.addRelevantStack(builder, tempRecipe.method_8110(level.method_30349()), pageNum);
			return tempRecipe;
		}

		PatchouliAPI.LOGGER.warn("Recipe {} (of type {}) not found", res, class_7923.field_41188.method_10221(recipeType));
		return null;
	}

}
