package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.base.PersistentData.Bookmark;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.LiquidBlockVertexConsumer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;
import vazkii.patchouli.xplat.IClientXplatAbstractions;

import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3610;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class PageMultiblock extends PageWithText {
	private static final class_5819 RAND = class_5819.method_43053();

	String name = "";
	@SerializedName("multiblock_id") class_2960 multiblockId;

	@SerializedName("multiblock") SerializedMultiblock serializedMultiblock;

	@SerializedName("enable_visualize") boolean showVisualizeButton = true;

	private transient AbstractMultiblock multiblockObj;
	private transient class_4185 visualizeButton;

	@Override
	public void build(class_1937 level, BookEntry entry, BookContentsBuilder builder, int pageNum) {
		super.build(level, entry, builder, pageNum);
		if (multiblockId != null) {
			IMultiblock mb = MultiblockRegistry.MULTIBLOCKS.get(multiblockId);

			if (mb instanceof AbstractMultiblock) {
				multiblockObj = (AbstractMultiblock) mb;
			}
		}

		if (multiblockObj == null && serializedMultiblock != null) {
			multiblockObj = serializedMultiblock.toMultiblock();
		}

		if (multiblockObj == null) {
			throw new IllegalArgumentException("No multiblock located for " + multiblockId);
		}
	}

	@Override
	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		super.onDisplayed(parent, left, top);

		if (showVisualizeButton) {
			addButton(visualizeButton = new GuiButtonBookEye(parent, 12, 97, this::handleButtonVisualize));
		}
	}

	@Override
	public int getTextHeight() {
		return 115;
	}

	@Override
	public void render(class_332 graphics, int mouseX, int mouseY, float pticks) {
		int x = GuiBook.PAGE_WIDTH / 2 - 53;
		int y = 7;
		RenderSystem.enableBlend();
		graphics.method_51422(1F, 1F, 1F, 1F);
		GuiBook.drawFromTexture(graphics, book, x, y, 405, 149, 106, 106);

		parent.drawCenteredStringNoShadow(graphics, i18n(name), GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);

		if (multiblockObj != null) {
			renderMultiblock(graphics);
		}

		super.render(graphics, mouseX, mouseY, pticks);
	}

	public void handleButtonVisualize(class_4185 button) {
		var entryKey = parent.getEntry().getId();
		Bookmark bookmark = new Bookmark(entryKey, pageNum / 2);
		MultiblockVisualizationHandler.setMultiblock(multiblockObj, i18nText(name), bookmark, true);
		parent.addBookmarkButtons();

		if (!PersistentData.data.clickedVisualize) {
			PersistentData.data.clickedVisualize = true;
			PersistentData.save();
		}
	}

	private void renderMultiblock(class_332 graphics) {
		multiblockObj.setWorld(mc.field_1687);
		class_2382 size = multiblockObj.getSize();
		int sizeX = size.method_10263();
		int sizeY = size.method_10264();
		int sizeZ = size.method_10260();
		float maxX = 90;
		float maxY = 90;
		float diag = (float) Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
		float scaleX = maxX / diag;
		float scaleY = maxY / sizeY;
		float scale = -Math.min(scaleX, scaleY);

		int xPos = GuiBook.PAGE_WIDTH / 2;
		int yPos = 60;
		graphics.method_51448().method_22903();
		graphics.method_51448().method_46416(xPos, yPos, 100);
		graphics.method_51448().method_22905(scale, scale, scale);
		graphics.method_51448().method_46416(-(float) sizeX / 2, -(float) sizeY / 2, 0);

		// Initial eye pos somewhere off in the distance in the -Z direction
		Vector4f eye = new Vector4f(0, 0, -100, 1);
		Matrix4f rotMat = new Matrix4f();
		rotMat.identity();

		// For each GL rotation done, track the opposite to keep the eye pos accurate
		graphics.method_51448().method_22907(class_7833.field_40714.rotationDegrees(-30F));
		rotMat.rotation(class_7833.field_40714.rotationDegrees(30));

		float offX = (float) -sizeX / 2;
		float offZ = (float) -sizeZ / 2 + 1;

		float time = parent.ticksInBook * 0.5F;
		if (!class_437.method_25442()) {
			time += ClientTicker.partialTicks;
		}
		graphics.method_51448().method_46416(-offX, 0, -offZ);
		graphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(time));
		rotMat.rotation(class_7833.field_40716.rotationDegrees(-time));
		graphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(45));
		rotMat.rotation(class_7833.field_40716.rotationDegrees(-45));
		graphics.method_51448().method_46416(offX, 0, offZ);

		// Finally apply the rotations
		eye.mul(rotMat);
		//eye.perspectiveDivide();//TODO find what replaces this
		/* TODO XXX This does not handle visualization of sparse multiblocks correctly.
			Dense multiblocks store everything in positive X/Z, so this works, but sparse multiblocks store everything from the JSON as-is.
			Potential solution: Rotate around the offset vars of the multiblock, and add AABB method for extent of the multiblock
		*/
		renderElements(graphics, multiblockObj, class_2338.method_10097(class_2338.field_10980, new class_2338(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);

		graphics.method_51448().method_22909();
	}

	private void renderElements(class_332 graphics, AbstractMultiblock mb, Iterable<? extends class_2338> blocks, Vector4f eye) {
		graphics.method_51448().method_22903();
		graphics.method_51422(1F, 1F, 1F, 1F);
		graphics.method_51448().method_46416(0, 0, -1);

		class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
		doWorldRenderPass(graphics, mb, blocks, buffers, eye);
		doTileEntityRenderPass(graphics, mb, blocks, buffers, eye);

		// todo 1.15 transparency sorting
		buffers.method_22993();
		graphics.method_51448().method_22909();
	}

	private void doWorldRenderPass(class_332 graphics, AbstractMultiblock mb, Iterable<? extends class_2338> blocks, final @NotNull class_4597.class_4598 buffers, Vector4f eye) {
		for (class_2338 pos : blocks) {
			class_2680 bs = mb.method_8320(pos);
			graphics.method_51448().method_22903();
			graphics.method_51448().method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());

			final class_3610 fluidState = bs.method_26227();
			final class_776 blockRenderer = class_310.method_1551().method_1541();
			if (!fluidState.method_15769()) {
				final class_1921 layer = class_4696.method_23680(fluidState);
				final class_4588 buffer = buffers.getBuffer(layer);
				blockRenderer.method_3352(pos, mb, new LiquidBlockVertexConsumer(buffer, graphics.method_51448(), pos), bs, fluidState);
			}
			IClientXplatAbstractions.INSTANCE.renderForMultiblock(bs, pos, mb, graphics.method_51448(), buffers, RAND);
			graphics.method_51448().method_22909();
		}
	}

	// Hold errored TEs weakly, this may cause some dupe errors but will prevent spamming it every frame
	private final transient Set<class_2586> erroredTiles = Collections.newSetFromMap(new WeakHashMap<>());

	private void doTileEntityRenderPass(class_332 graphics, AbstractMultiblock mb, Iterable<? extends class_2338> blocks, class_4597 buffers, Vector4f eye) {
		for (class_2338 pos : blocks) {
			class_2586 te = mb.method_8321(pos);
			if (te != null && !erroredTiles.contains(te)) {
				// Doesn't take pos anymore, maybe a problem?
				te.method_31662(mc.field_1687);

				// fake cached state in case the renderer checks it as we don't want to query the actual world
				te.method_31664(mb.method_8320(pos));

				graphics.method_51448().method_22903();
				graphics.method_51448().method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
				try {
					class_827<class_2586> renderer = class_310.method_1551().method_31975().method_3550(te);
					if (renderer != null) {
						renderer.method_3569(te, ClientTicker.partialTicks, graphics.method_51448(), buffers, 0xF000F0, class_4608.field_21444);
					}
				} catch (Exception e) {
					erroredTiles.add(te);
					PatchouliAPI.LOGGER.error("An exception occured rendering tile entity", e);
				} finally {
					graphics.method_51448().method_22909();
				}
			}
		}
	}
}
