package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.patchouli.client.book.gui.GuiBook;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class GuiButtonBook extends class_4185 {

	protected final GuiBook parent;
	protected final int u, v;
	private final Supplier<Boolean> displayCondition;
	protected final List<class_2561> tooltip;

	public GuiButtonBook(GuiBook parent, int x, int y, int u, int v, int w, int h, class_4241 onPress, class_2561... tooltip) {
		this(parent, x, y, u, v, w, h, () -> true, onPress, tooltip);
	}

	public GuiButtonBook(GuiBook parent, int x, int y, int u, int v, int w, int h, Supplier<Boolean> displayCondition, class_4241 onPress, class_2561... tooltip) {
		super(x, y, w, h, tooltip[0], onPress, field_40754);
		this.parent = parent;
		this.u = u;
		this.v = v;
		this.displayCondition = displayCondition;
		this.tooltip = Arrays.asList(tooltip);
	}

	@Override
	public final void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		field_22763 = field_22764 = displayCondition.get();
		super.method_25394(graphics, mouseX, mouseY, partialTicks);
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
		GuiBook.drawFromTexture(graphics, parent.book, method_46426(), method_46427(), u + (method_25367() ? field_22758 : 0), v, field_22758, field_22759);
		if (method_25367()) {
			parent.setTooltip(getTooltipLines());
		}
	}

	@Override
	public void method_25354(class_1144 soundHandlerIn) {
		GuiBook.playBookFlipSound(parent.book);
	}

	public List<class_2561> getTooltipLines() {
		return tooltip;
	}

}
