package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.client.gui.GuiAdvancementsExt;
import vazkii.patchouli.common.book.Book;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;

import static vazkii.patchouli.client.book.gui.GuiBookEntryList.ENTRIES_IN_FIRST_PAGE;

public class GuiBookLanding extends GuiBook {

	@Nullable BookTextRenderer text;
	int loadedCategories = 0;

	final List<class_4185> pamphletEntryButtons = new ArrayList<>();
	List<BookEntry> entriesInPamphlet;

	public GuiBookLanding(Book book) {
		super(book, class_2561.method_43471(book.name));
	}

	@Override
	public void method_25426() {
		super.method_25426();

		text = new BookTextRenderer(this, class_2561.method_43471(book.landingText), LEFT_PAGE_X, TOP_PADDING + 25);

		boolean disableBar = !book.showProgress || !book.advancementsEnabled();

		int x = bookLeft + (disableBar ? 25 : 20);
		int y = bookTop + FULL_HEIGHT - (disableBar ? 25 : 62);
		int dist = 15;
		int pos = 0;

		// Resize
		if (maxScale > 2) {
			method_37063(new GuiButtonBookResize(this, x + (pos++) * dist, y, this::handleButtonResize));
		}

		// History
		method_37063(new GuiButtonBook(this, x + (pos++) * dist, y, 330, 31, 11, 11, this::handleButtonHistory,
				class_2561.method_43471("patchouli.gui.lexicon.button.history")));

		// Advancements
		if (book.advancementsTab != null) {
			method_37063(new GuiButtonBook(this, x + (pos++) * dist, y, 330, 20, 11, 11, this::handleButtonAdvancements,
					class_2561.method_43471("patchouli.gui.lexicon.button.advancements")));
		}

		if (class_310.method_1551().field_1724.method_7337()) {
			method_37063(new GuiButtonBook(this, x + (pos++) * dist, y, 308, 9, 11, 11, this::handleButtonEdit,
					class_2561.method_43471("patchouli.gui.lexicon.button.editor"),
					class_2561.method_43471("patchouli.gui.lexicon.button.editor.info").method_27692(class_124.field_1080)));
		}

		if (this.book.getContents().pamphletCategory == null) {
			int i = 0;
			List<BookCategory> categories = new ArrayList<>(book.getContents().categories.values());
			Collections.sort(categories);

			for (BookCategory category : categories) {
				if (category.getParentCategory() != null || category.shouldHide()) {
					continue;
				}

				addCategoryButton(i, category);
				i++;
			}
			addCategoryButton(i, null);
			loadedCategories = i + 1;
		} else {
			entriesInPamphlet = new ArrayList<>(book.getContents().entries.values());
			entriesInPamphlet.removeIf(BookEntry::shouldHide);
			Collections.sort(entriesInPamphlet);
			buildEntryButtons();

			// yes, technically we loaded one category, but for display purposes
			// it's more like we loaded zero.
			loadedCategories = 0;
		}

	}

	private void addCategoryButton(int i, BookCategory category) {
		int x = RIGHT_PAGE_X + 10 + (i % 4) * 24;
		int y = TOP_PADDING + 25 + (i / 4) * 24;

		if (category == null) {
			method_37063(new GuiButtonCategory(this, x, y, book.getIcon(), class_2561.method_43471("patchouli.gui.lexicon.index"), this::handleButtonIndex));
		} else {
			method_37063(new GuiButtonCategory(this, x, y, category, this::handleButtonCategory));
		}
	}

	@Override
	void drawForegroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		if (text != null) {
			text.render(graphics, mouseX, mouseY);
		}

		int topSeparator = TOP_PADDING + 12;
		int bottomSeparator = topSeparator + 25 + 24 * ((loadedCategories - 1) / 4 + 1);

		drawHeader(graphics);

		if (book.getContents().pamphletCategory == null) {
			drawCenteredStringNoShadow(graphics, class_1074.method_4662("patchouli.gui.lexicon.categories"), RIGHT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);

			drawSeparator(graphics, book, RIGHT_PAGE_X, topSeparator);

			if (loadedCategories <= 16) {
				drawSeparator(graphics, book, RIGHT_PAGE_X, bottomSeparator);
			}
		}

		if (book.getContents().isErrored()) {
			int x = RIGHT_PAGE_X + PAGE_WIDTH / 2;
			int y = bottomSeparator + 12;

			drawCenteredStringNoShadow(graphics, class_1074.method_4662("patchouli.gui.lexicon.loading_error"), x, y, 0xFF0000);
			drawCenteredStringNoShadow(graphics, class_1074.method_4662("patchouli.gui.lexicon.loading_error_hover"), x, y + 10, 0x777777);

			x -= PAGE_WIDTH / 2;
			y -= 4;

			if (isMouseInRelativeRange(mouseX, mouseY, x, y, PAGE_WIDTH, 20)) {
				makeErrorTooltip();
			}
		}

		drawProgressBar(graphics, book, mouseX, mouseY, (e) -> true);
	}

	@Override
	void onPageChanged() {
		buildEntryButtons();
	}

	private void buildEntryButtons() {
		removeDrawablesIn(pamphletEntryButtons);
		pamphletEntryButtons.clear();

		maxSpreads = 1;

		addEntryButtons(RIGHT_PAGE_X, TOP_PADDING, 0, ENTRIES_IN_FIRST_PAGE);
	}

	private void addEntryButtons(int x, int y, int start, int count) {
		if (!this.book.getContents().isErrored()) {
			for (int i = 0; i < count && (i + start) < entriesInPamphlet.size(); i++) {
				class_4185 button = new GuiButtonEntry(this, bookLeft + x, bookTop + y + i * 11, entriesInPamphlet.get(start + i),
						this::handleButtonPamphletEntry);
				method_37063(button);
				pamphletEntryButtons.add(button);
			}
		}
	}

	private void drawHeader(class_332 graphics) {
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
		drawFromTexture(graphics, book, -8, 12, 0, 180, 140, 31);

		int color = book.nameplateColor;
		graphics.method_51439(field_22793, book.getBookItem().method_7964(), 13, 16, color, false);
		class_2561 toDraw = book.getSubtitle().method_27696(book.getFontStyle());
		graphics.method_51439(field_22793, toDraw, 24, 24, color, false);
	}

	private void makeErrorTooltip() {
		Throwable e = book.getContents().getException();

		List<class_2561> lines = new ArrayList<>();
		while (e != null) {
			String msg = e.getMessage();
			if (msg != null && !msg.isEmpty()) {
				lines.add(class_2561.method_43470(e.getMessage()));
			}
			e = e.getCause();
		}

		if (!lines.isEmpty()) {
			lines.add(class_2561.method_43471("patchouli.gui.lexicon.loading_error_log").method_27692(class_124.field_1060));
			setTooltip(lines);
		}
	}

	@Override
	public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
		return text != null && text.click(mouseX, mouseY, mouseButton)
				|| super.mouseClickedScaled(mouseX, mouseY, mouseButton);
	}

	public void handleButtonIndex(class_4185 button) {
		displayLexiconGui(new GuiBookIndex(book), true);
	}

	public void handleButtonCategory(class_4185 button) {
		displayLexiconGui(new GuiBookCategory(book, ((GuiButtonCategory) button).getCategory()), true);
	}

	private void handleButtonHistory(class_4185 button) {
		displayLexiconGui(new GuiBookHistory(book), true);
	}

	private void handleButtonAdvancements(class_4185 button) {
		field_22787.method_1507(new GuiAdvancementsExt(field_22787.field_1724.field_3944.method_2869(), this, book.advancementsTab));
	}

	private void handleButtonEdit(class_4185 button) {
		if (method_25442()) {
			long time = System.currentTimeMillis();
			book.reloadContents(field_22787.field_1687, true);
			book.reloadLocks(false);
			displayLexiconGui(new GuiBookLanding(book), false);
			field_22787.field_1724.method_7353(class_2561.method_43469("patchouli.gui.lexicon.reloaded", (System.currentTimeMillis() - time)), false);
		} else {
			displayLexiconGui(new GuiBookWriter(book), true);
		}
	}

	public void handleButtonResize(class_4185 button) {
		if (PersistentData.data.bookGuiScale >= maxScale) {
			PersistentData.data.bookGuiScale = 0;
		} else {
			PersistentData.data.bookGuiScale = Math.max(2, PersistentData.data.bookGuiScale + 1);
		}

		PersistentData.save();
		displayLexiconGui(this, false);
	}

	public void handleButtonPamphletEntry(class_4185 button) {
		GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry) button).getEntry());
	}
}
