package vazkii.patchouli.client.book.gui;

import vazkii.patchouli.api.PatchouliConfigAccess.TextOverflowMode;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5251;

public class BookTextRenderer {
	private final Book book;

	private final List<Word> words;
	private final float scale;

	public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y) {
		this(gui, text, x, y, GuiBook.PAGE_WIDTH, GuiBook.TEXT_LINE_HEIGHT, gui.book.textColor);
	}

	public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y, int width, int lineHeight, int baseColor) {
		this.book = gui.book;
		class_2561 text1;
		if (book.i18n && text.method_10851() instanceof class_2585 lc) {
			text1 = class_2561.method_43470(class_1074.method_4662(lc.comp_737()));
		} else {
			text1 = text;
		}
		class_2583 baseStyle = book.getFontStyle().method_27703(class_5251.method_27717(baseColor));

		var parser = new BookTextParser(gui, this.book, x, y, width, lineHeight, baseStyle);
		var overflowMode = this.book.overflowMode;
		if (overflowMode == null) {
			overflowMode = PatchouliConfig.get().overflowMode();
		}
		var layouter = new TextLayouter(gui, x, y, lineHeight, width, overflowMode);
		layouter.layout(class_310.method_1551().field_1772, parser.parse(text1));
		this.scale = layouter.getScale();
		this.words = layouter.getWords();
	}

	private double rescale(double in, double origin) {
		return origin + (in - origin) / scale;
	}

	public void render(class_332 graphics, int mouseX, int mouseY) {
		if (!words.isEmpty()) {
			class_327 font = class_310.method_1551().field_1772;
			class_2583 style = book.getFontStyle();
			Word first = words.get(0);
			graphics.method_51448().method_22903();
			graphics.method_51448().method_46416(first.x, first.y, 0);
			graphics.method_51448().method_22905(scale, scale, 1.0f);
			graphics.method_51448().method_46416(-first.x, -first.y, 0);
			int scaledX = (int) rescale(mouseX, first.x);
			int scaledY = (int) rescale(mouseY, first.y);
			words.forEach(word -> word.render(graphics, font, style, scaledX, scaledY));
			graphics.method_51448().method_22909();
		}
	}

	public boolean click(double mouseX, double mouseY, int mouseButton) {
		if (!words.isEmpty()) {
			Word first = words.get(0);
			double scaledX = rescale(mouseX, first.x);
			double scaledY = rescale(mouseY, first.y);
			for (Word word : words) {
				if (word.click(scaledX, scaledY, mouseButton)) {
					return true;
				}
			}
		}

		return false;
	}
}
