package vazkii.patchouli.client.book;

import com.google.gson.*;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.page.*;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.util.SerializationUtil;

import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3518;

public class ClientBookRegistry {

	public final Map<class_2960, Class<? extends BookPage>> pageTypes = new HashMap<>();

	public final Gson gson = new GsonBuilder()
			.registerTypeHierarchyAdapter(BookPage.class, new LexiconPageAdapter())
			.registerTypeHierarchyAdapter(TemplateComponent.class, new TemplateComponentAdapter())
			.create();
	public String currentLang;

	public static final ClientBookRegistry INSTANCE = new ClientBookRegistry();

	private ClientBookRegistry() {}

	public void init() {
		addPageTypes();
	}

	private void addPageTypes() {
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "text"), PageText.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "crafting"), PageCrafting.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "smelting"), PageSmelting.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "blasting"), PageBlasting.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "smoking"), PageSmoking.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "campfire"), PageCampfireCooking.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "smithing"), PageSmithing.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "stonecutting"), PageStonecutting.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "image"), PageImage.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "spotlight"), PageSpotlight.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "empty"), PageEmpty.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "multiblock"), PageMultiblock.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "link"), PageLink.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "relations"), PageRelations.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "entity"), PageEntity.class);
		pageTypes.put(new class_2960(PatchouliAPI.MOD_ID, "quest"), PageQuest.class);
	}

	public void reload() {
		currentLang = class_310.method_1551().method_1526().method_4669();
		BookRegistry.INSTANCE.reloadContents(class_310.method_1551().field_1687);
	}

	public void reloadLocks(boolean suppressToasts) {
		BookRegistry.INSTANCE.books.values().forEach(b -> b.reloadLocks(suppressToasts));
	}

	/**
	 * @param entryId Entry to force to the top of the stack
	 * @param page    Zero-indexed page in the entry to force. Ignored if {@code entryId} is null.
	 */
	public void displayBookGui(class_2960 bookStr, @Nullable class_2960 entryId, int page) {
		class_310 mc = class_310.method_1551();
		currentLang = mc.method_1526().method_4669();

		Book book = BookRegistry.INSTANCE.books.get(bookStr);

		if (book != null) {
			book.getContents().checkValidCurrentEntry();

			if (entryId != null) {
				book.getContents().setTopEntry(entryId, page);
			}

			book.getContents().openLexiconGui(book.getContents().getCurrentGui(), false);

			if (mc.field_1724 != null) {
				class_3414 sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.BOOK_OPEN);
				mc.field_1724.method_5783(sfx, 1F, (float) (0.7 + Math.random() * 0.4));
			}
		}
	}

	public static class LexiconPageAdapter implements JsonDeserializer<BookPage> {

		@Override
		public BookPage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
			if (json instanceof JsonPrimitive prim && prim.isString()) {
				// Shortcut: make strings instead of objects shortcut to text pages
				var out = new PageText();
				out.setText(prim.getAsString());
				return out;
			}

			JsonObject obj = json.getAsJsonObject();
			String string = class_3518.method_15265(obj, "type");
			if (string.indexOf(':') < 0) {
				string = PatchouliAPI.MOD_ID + ":" + string;
			}
			class_2960 type = new class_2960(string);
			Class<? extends BookPage> clazz = ClientBookRegistry.INSTANCE.pageTypes.get(type);
			if (clazz == null) {
				clazz = PageTemplate.class;
			}

			BookPage page = SerializationUtil.RAW_GSON.fromJson(json, clazz);
			page.sourceObject = obj;

			return page;
		}

	}

	public static class TemplateComponentAdapter implements JsonDeserializer<TemplateComponent> {

		@Override
		public TemplateComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
			JsonObject obj = json.getAsJsonObject();
			JsonPrimitive prim = (JsonPrimitive) obj.get("type");
			class_2960 type = new class_2960(prim.getAsString());
			Class<? extends TemplateComponent> clazz = BookTemplate.componentTypes.get(type);

			if (clazz == null) {
				return null;
			}

			TemplateComponent component = SerializationUtil.RAW_GSON.fromJson(json, clazz);
			component.sourceObject = obj;

			return component;
		}

	}
}
