package vazkii.patchouli.client.book;

import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.util.ItemStackUtil;

public sealed interface BookIcon permits BookIcon.StackIcon,BookIcon.TextureIcon {
	void render(class_332 graphics, int x, int y);

	record StackIcon(class_1799 stack) implements BookIcon {
		@Override
		public void render(class_332 graphics, int x, int y) {
			graphics.method_51427(stack(), x, y);
			graphics.method_51431(class_310.method_1551().field_1772, stack(), x, y);
		}
	}

	record TextureIcon(class_2960 texture) implements BookIcon {
		@Override
		public void render(class_332 graphics, int x, int y) {
			graphics.method_51422(1F, 1F, 1F, 1F);
			graphics.method_25290(texture(), x, y, 0, 0, 16, 16, 16, 16);
		}
	}

	static BookIcon from(String str) {
		if (str.endsWith(".png")) {
			return new TextureIcon(new class_2960(str));
		} else {
			try {
				class_1799 stack = ItemStackUtil.loadStackFromString(str);
				return new StackIcon(stack);
			} catch (Exception e) {
				PatchouliAPI.LOGGER.warn("Invalid icon item stack: {}", e.getMessage());
				return new StackIcon(class_1799.field_8037);
			}
		}
	}

}
