package vazkii.patchouli.mixin.client;

import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_344;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_485;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.patchouli.client.gui.GuiButtonInventoryBook;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

@Mixin(class_490.class)
public abstract class MixinInventoryScreen extends class_485<class_1723> {
	public MixinInventoryScreen(class_1723 container, class_1661 playerInventory, class_2561 text) {
		super(container, playerInventory, text);
	}

	@Inject(at = @At("RETURN"), method = "init()V")
	public void onGuiInitPost(CallbackInfo info) {
		String bookID = PatchouliConfig.inventoryButtonBook.getValue();
		Book book = BookRegistry.INSTANCE.books.get(new class_2960(bookID));
		if (book == null) {
			return;
		}

		class_4068 replaced = null;
		class_4185 replacement = null;
		for (int i = 0; i < ((AccessorScreen) this).getRenderables().size(); i++) {
			class_4068 button = ((AccessorScreen) this).getRenderables().get(i);
			if (button instanceof class_344 tex) {
				replaced = button;
				replacement = new GuiButtonInventoryBook(book, tex.field_22760, tex.field_22761 - 1);
				((AccessorScreen) this).getRenderables().set(i, replacement);
				break;
			}
		}

		int i = ((AccessorScreen) this).getChildren().indexOf(replaced);
		if (i >= 0) {
			((AccessorScreen) this).getChildren().set(i, replacement);
		}

		i = ((AccessorScreen) this).getNarratables().indexOf(replaced);
		if (i >= 0) {
			((AccessorScreen) this).getNarratables().set(i, replacement);
		}
	}
}
