package vazkii.patchouli.common.recipe;

import com.google.gson.JsonObject;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

public abstract class BookRecipe<T extends class_3955> implements class_3955 {
	protected final T compose;
	private final class_2960 outputBook;

	protected BookRecipe(T compose, class_2960 outputBook) {
		this.compose = compose;
		this.outputBook = outputBook;
	}

	@Override
	public boolean matches(class_1715 inventory, class_1937 world) {
		return compose.method_8115(inventory, world);
	}

	@Override
	public class_1799 assemble(class_1715 inventory) {
		return method_8110();
	}

	@Override
	public boolean method_8113(int width, int height) {
		return compose.method_8113(width, height);
	}

	@Override
	public class_1799 method_8110() {
		return PatchouliAPI.get().getBookStack(outputBook);
	}

	@Override
	public class_2960 method_8114() {
		return compose.method_8114();
	}

	@Override
	public abstract class_1865<?> method_8119();

	protected abstract static class WrapperSerializer<R extends class_3955, T extends BookRecipe<R>> implements class_1865<T> {
		protected abstract class_1865<R> getSerializer();

		protected abstract T getRecipe(R recipe, class_2960 outputBook);

		@Override
		public T method_8121(class_2960 id, JsonObject json) {
			if (!json.has("result")) {
				JsonObject object = new JsonObject();
				object.addProperty("item", PatchouliItems.BOOK_ID.toString());
				json.add("result", object);
			}
			R recipe = getSerializer().method_8121(id, json);

			class_2960 outputBook = new class_2960(class_3518.method_15265(json, "book"));
			if (!BookRegistry.INSTANCE.books.containsKey(outputBook)) {
				Patchouli.LOGGER.warn("Book {} in recipe {} does not exist!", outputBook, id);
			}

			return getRecipe(recipe, outputBook);
		}

		@Override
		public T method_8122(class_2960 id, class_2540 buf) {
			R recipe = getSerializer().method_8122(id, buf);
			class_2960 outputBook = buf.method_10810();

			return getRecipe(recipe, outputBook);
		}

		@Override
		public void toNetwork(class_2540 buf, T recipe) {
			getSerializer().method_8124(buf, recipe.compose);
			buf.method_10812(recipe.method_8114());
		}
	}
}
