package vazkii.patchouli.common.multiblock;

import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class StateMatcher implements IStateMatcher {

	public static final StateMatcher ANY = displayOnly(class_2246.field_10124.method_9564());
	public static final StateMatcher AIR = fromPredicate(class_2246.field_10124.method_9564(), (w, p, s) -> s.method_26215());

	private final class_2680 displayState;
	private final TriPredicate<class_1922, class_2338, class_2680> statePredicate;

	private StateMatcher(class_2680 displayState, TriPredicate<class_1922, class_2338, class_2680> statePredicate) {
		this.displayState = displayState;
		this.statePredicate = statePredicate;
	}

	public static StateMatcher fromPredicate(class_2680 display, Predicate<class_2680> predicate) {
		return new StateMatcher(display, (world, pos, state) -> predicate.test(state));
	}

	public static StateMatcher fromPredicate(class_2248 display, Predicate<class_2680> predicate) {
		return fromPredicate(display.method_9564(), predicate);
	}

	public static StateMatcher fromPredicate(class_2680 display, TriPredicate<class_1922, class_2338, class_2680> predicate) {
		return new StateMatcher(display, predicate);
	}

	public static StateMatcher fromPredicate(class_2248 display, TriPredicate<class_1922, class_2338, class_2680> predicate) {
		return new StateMatcher(display.method_9564(), predicate);
	}

	public static StateMatcher fromState(class_2680 displayState, boolean strict) {
		return fromPredicate(displayState,
				strict ? ((state) -> state == displayState)
						: ((state) -> state.method_26204() == displayState.method_26204()));
	}

	public static StateMatcher fromStateWithFilter(class_2680 state, Predicate<class_2769<?>> filter) {
		return fromPredicate(state, state1 -> {
			if (state.method_26204() != state1.method_26204()) {
				return false;
			}
			return state1.method_28501()
					.stream()
					.filter(filter)
					.allMatch(property -> state1.method_28498(property) &&
							state.method_28498(property) &&
							Objects.equals(state.method_11654(property), state1.method_11654(property)));
		});
	}

	public static StateMatcher fromState(class_2680 displayState) {
		return fromState(displayState, true);
	}

	public static StateMatcher fromBlockLoose(class_2248 block) {
		return fromState(block.method_9564(), false);
	}

	public static StateMatcher fromBlockStrict(class_2248 block) {
		return fromState(block.method_9564(), true);
	}

	public static StateMatcher displayOnly(class_2680 state) {
		return new StateMatcher(state, (w, p, s) -> true);
	}

	public static StateMatcher displayOnly(class_2248 block) {
		return displayOnly(block.method_9564());
	}

	@Override
	public class_2680 getDisplayedState(int ticks) {
		return displayState;
	}

	@Override
	public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
		return statePredicate;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		StateMatcher that = (StateMatcher) o;
		return statePredicate.equals(that.statePredicate);
	}

	@Override
	public int hashCode() {
		return Objects.hash(statePredicate);
	}
}
