package vazkii.patchouli.common.multiblock;

import vazkii.patchouli.api.IMultiblock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;

public class MultiblockRegistry {

	public static final Map<class_2960, IMultiblock> MULTIBLOCKS = new ConcurrentHashMap<>();

	public static IMultiblock registerMultiblock(class_2960 location, IMultiblock multiblock) {
		IMultiblock prev = MULTIBLOCKS.put(location, multiblock);
		if (prev != null) {
			throw new IllegalArgumentException("Multiblock " + location + " already registered");
		} else {
			return multiblock.setId(location);
		}
	}

}
