package vazkii.patchouli.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OpenBookCommand {
	private static final SuggestionProvider<class_2168> BOOK_ID_SUGGESTER =
			(ctx, builder) -> {
				List<class_2960> ids = new ArrayList<>();
				for (Map.Entry<class_2960, Book> e : BookRegistry.INSTANCE.books.entrySet()) {
					if (!e.getValue().isExtension) {
						ids.add(e.getKey());
					}
				}
				return class_2172.method_9270(ids, builder);
			};

	public static void register(CommandDispatcher<class_2168> disp) {
		disp.register(class_2170.method_9247("open-patchouli-book")
				.requires(cs -> cs.method_9259(2))
				.then(class_2170.method_9244("targets", class_2186.method_9308())
						.then(class_2170.method_9244("book", class_2232.method_9441())
								.suggests(BOOK_ID_SUGGESTER)
								.executes(ctx -> doIt(class_2186.method_9312(ctx, "targets"),
										class_2232.method_9443(ctx, "book"),
										null, 0))
								.then(class_2170.method_9244("entry", class_2232.method_9441())
										.then(class_2170.method_9244("page", IntegerArgumentType.integer(0))
												.executes(ctx -> doIt(class_2186.method_9312(ctx, "targets"),
														class_2232.method_9443(ctx, "book"),
														class_2232.method_9443(ctx, "entry"),
														IntegerArgumentType.getInteger(ctx, "page"))))))));
	}

	private static int doIt(Collection<class_3222> players, class_2960 book, @Nullable class_2960 entry, int page) {
		for (class_3222 player : players) {
			if (entry != null) {
				PatchouliAPI.get().openBookEntry(player, book, entry, page);
			} else {
				PatchouliAPI.get().openBookGUI(player, book);
			}
		}
		return players.size();
	}
}
