package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293.class_5596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;

import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class TooltipHandler {
	private static float lexiconLookupTime = 0;

	public static void onTooltip(class_4587 ms, class_1799 stack, int mouseX, int mouseY) {
		class_310 mc = class_310.method_1551();
		int tooltipX = mouseX;
		int tooltipY = mouseY - 4;

		if (mc.field_1724 != null && !(mc.field_1755 instanceof GuiBook)) {
			int lexSlot = -1;
			class_1799 lexiconStack = class_1799.field_8037;
			Pair<BookEntry, Integer> lexiconEntry = null;

			for (int i = 0; i < class_1661.method_7368(); i++) {
				class_1799 stackAt = mc.field_1724.method_31548().method_5438(i);
				if (!stackAt.method_7960()) {
					Book book = ItemStackUtil.getBookFromStack(stackAt);
					if (book != null) {
						Pair<BookEntry, Integer> entry = book.getContents().getEntryForStack(stack);

						if (entry != null && !entry.getFirst().isLocked()) {
							lexiconStack = stackAt;
							lexSlot = i;
							lexiconEntry = entry;
							break;
						}
					}
				}
			}

			if (lexSlot > -1) {
				int x = tooltipX - 34;
				RenderSystem.disableDepthTest();

				class_332.method_25294(ms, x - 4, tooltipY - 4, x + 20, tooltipY + 26, 0x44000000);
				class_332.method_25294(ms, x - 6, tooltipY - 6, x + 22, tooltipY + 28, 0x44000000);

				if (PatchouliConfig.useShiftForQuickLookup.getValue() ? class_437.method_25442() : class_437.method_25441()) {
					lexiconLookupTime += ClientTicker.delta;

					int cx = x + 8;
					int cy = tooltipY + 8;
					float r = 12;
					float time = 20F;
					float angles = lexiconLookupTime / time * 360F;

					//RenderSystem.disableLighting();
					RenderSystem.disableTexture();
					//RenderSystem.shadeModel(GL11.GL_SMOOTH);
					RenderSystem.enableBlend();
					RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

					class_287 buf = class_289.method_1348().method_1349();
					buf.method_1328(class_5596.field_27381, class_290.field_1576);

					float a = 0.5F + 0.2F * ((float) Math.cos(ClientTicker.total / 10) * 0.5F + 0.5F);
					buf.method_22912(cx, cy, 0).method_22915(0F, 0.5F, 0F, a).method_1344();

					for (float i = angles; i > 0; i--) {
						double rad = (i - 90) / 180F * Math.PI;
						buf.method_22912(cx + Math.cos(rad) * r, cy + Math.sin(rad) * r, 0).method_22915(0F, 1F, 0F, 1F).method_1344();
					}

					buf.method_22912(cx, cy, 0).method_22915(0F, 1F, 0F, 0F).method_1344();
					class_289.method_1348().method_1350();

					RenderSystem.disableBlend();
					RenderSystem.enableTexture();
					//RenderSystem.shadeModel(GL11.GL_FLAT);

					if (lexiconLookupTime >= time) {
						mc.field_1724.method_31548().field_7545 = lexSlot;
						int spread = lexiconEntry.getSecond();
						ClientBookRegistry.INSTANCE.displayBookGui(lexiconEntry.getFirst().getBook().id, lexiconEntry.getFirst().getId(), spread * 2);
					}
				} else {
					lexiconLookupTime = 0F;
				}

				mc.method_1480().field_4730 = 300;
				RenderHelper.renderItemStackInGui(ms, lexiconStack, x, tooltipY);
				mc.method_1480().field_4730 = 0;
				//RenderSystem.disableLighting();

				ms.method_22903();
				ms.method_22904(0, 0, 500);
				mc.field_1772.method_1720(ms, "?", x + 10, tooltipY + 8, 0xFFFFFFFF);

				ms.method_22905(0.5F, 0.5F, 1F);
				boolean mac = class_310.field_1703;
				class_2561 key = new class_2585(PatchouliConfig.useShiftForQuickLookup.getValue() ? "Shift" : mac ? "Cmd" : "Ctrl")
						.method_27692(class_124.field_1067);
				mc.field_1772.method_30881(ms, key, (x + 10) * 2 - 16, (tooltipY + 8) * 2 + 20, 0xFFFFFFFF);
				ms.method_22909();

				RenderSystem.enableDepthTest();
			} else {
				lexiconLookupTime = 0F;
			}
		} else {
			lexiconLookupTime = 0F;
		}
	}
}
