package vazkii.patchouli.client.handler;

import com.mojang.datafixers.util.Pair;

import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookRightClickHandler {

	private static void onRenderHUD(class_4587 ms, float partialTicks) {
		class_310 mc = class_310.method_1551();
		class_1657 player = mc.field_1724;
		class_1799 bookStack = player.method_6047();
		if (mc.field_1755 == null) {
			Book book = ItemStackUtil.getBookFromStack(bookStack);

			if (book != null) {
				Pair<BookEntry, Integer> hover = getHoveredEntry(book);
				if (hover != null) {
					BookEntry entry = hover.getFirst();
					if (!entry.isLocked()) {
						class_1041 window = mc.method_22683();
						int x = window.method_4486() / 2 + 3;
						int y = window.method_4502() / 2 + 3;
						entry.getIcon().render(ms, x, y);
						ms.method_22905(0.5F, 0.5F, 1);
						RenderHelper.renderItemStackInGui(ms, bookStack, (x + 8) * 2, (y + 8) * 2);
						ms.method_22905(2F, 2F, 1F);

						mc.field_1772.method_30883(ms, entry.getName(), x + 18, y + 3, 0xFFFFFF);

						ms.method_22903();
						ms.method_22905(0.75F, 0.75F, 1F);
						class_2561 s = new class_2588("patchouli.gui.lexicon." + (player.method_5715() ? "view" : "sneak"))
								.method_27692(class_124.field_1056);
						mc.field_1772.method_30883(ms, s, (x + 18) / 0.75F, (y + 14) / 0.75F, 0xBBBBBB);
						ms.method_22909();
					}
				}
			}
		}
	}

	public static void init() {
		HudRenderCallback.EVENT.register(BookRightClickHandler::onRenderHUD);
		UseBlockCallback.EVENT.register(BookRightClickHandler::onRightClick);
	}

	private static class_1269 onRightClick(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
		class_1799 bookStack = player.method_6047();

		if (world.field_9236 && player.method_5715()) {
			Book book = ItemStackUtil.getBookFromStack(bookStack);

			if (book != null) {
				Pair<BookEntry, Integer> hover = getHoveredEntry(book);
				if (hover != null) {
					int page = hover.getSecond() * 2;
					book.getContents().setTopEntry(hover.getFirst().getId(), page);
				}
			}
		}
		return class_1269.field_5811;
	}

	private static Pair<BookEntry, Integer> getHoveredEntry(Book book) {
		class_310 mc = class_310.method_1551();
		class_239 res = mc.field_1765;
		if (res instanceof class_3965) {
			class_2338 pos = ((class_3965) res).method_17777();
			class_2680 state = mc.field_1687.method_8320(pos);
			class_2248 block = state.method_26204();
			class_1799 picked = block.method_9574(mc.field_1687, pos, state);

			if (!picked.method_7960()) {
				return book.getContents().getEntryForStack(picked);
			}
		}

		return null;
	}

}
