package vazkii.patchouli.client.book.text;

import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

/**
 * A {@code Word} is the smallest textual unit of rendering in Patchouli, and knows its
 * position, dimensions, and formatting.
 */
public class Word {
	private final Book book;
	private final GuiBook gui;
	private final class_2561 text;
	private final List<Word> linkCluster;
	private final Supplier<Boolean> onClick;
	public final int x, y, width, height;

	public Word(GuiBook gui, Span span, class_5250 text, int x, int y, int strWidth, List<Word> cluster) {
		this.book = gui.book;
		this.gui = gui;
		this.x = x;
		this.y = y;
		this.width = strWidth;
		this.height = 8;
		this.onClick = span.onClick;
		this.linkCluster = cluster;
		if (!span.tooltip.getString().isEmpty()) {
			text = text.method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, span.tooltip)));
		}
		this.text = text;
	}

	public void render(class_4587 ms, class_327 font, class_2583 styleOverride, int mouseX, int mouseY) {
		class_5250 toRender = text.method_27661().method_27696(styleOverride);
		if (isClusterHovered(mouseX, mouseY)) {
			if (onClick != null) {
				toRender.method_27694(s -> s.method_27703(class_5251.method_27717(book.linkHoverColor)));
			}

			gui.method_25418(ms, text.method_10866(), (int) gui.getRelativeX(mouseX), (int) gui.getRelativeY(mouseY));
		}

		font.method_30883(ms, toRender, x, y, -1);
	}

	public boolean click(double mouseX, double mouseY, int mouseButton) {
		if (onClick != null && mouseButton == 0 && isHovered(mouseX, mouseY)) {
			return onClick.get();
		}

		return false;
	}

	private boolean isHovered(double mouseX, double mouseY) {
		return gui.isMouseInRelativeRange(mouseX, mouseY, x, y, width, height);
	}

	private boolean isClusterHovered(double mouseX, double mouseY) {
		if (linkCluster == null) {
			return isHovered(mouseX, mouseY);
		}

		for (Word w : linkCluster) {
			if (w.isHovered(mouseX, mouseY)) {
				return true;
			}
		}

		return false;
	}
}
