package vazkii.patchouli.client.book.text;

import vazkii.patchouli.api.IStyleStack;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

import javax.annotation.Nullable;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class SpanState implements IStyleStack {
	public final GuiBook gui;
	public final Book book;

	private class_2583 baseStyle;
	// In addition to caching the computed style for quick lookup,
	// this keeps a list of all modifications made to the style at each layer,
	// so that when we replace the base style, we can reconstruct the style stack.
	private final Deque<SpanPartialState> stateStack = new ArrayDeque<>();
	public class_5250 tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
	public Supplier<Boolean> onClick = null;
	public List<Span> cluster = null;
	public boolean isExternalLink = false; // will show the "external link" symbol next to the link as soon as the link is closed
	public boolean endingExternal = false; // will show the "external link" symbol next to the link immediately
	public int lineBreaks = 0; // force line breaks
	public int spacingLeft = 0; // add extra spacing
	public int spacingRight = 0;
	public final int spaceWidth;

	public SpanState(GuiBook gui, Book book, class_2583 baseStyle) {
		this.gui = gui;
		this.book = book;
		this.baseStyle = baseStyle;
		this.stateStack.push(new SpanPartialState(baseStyle, null));
		this.spaceWidth = class_310.method_1551().field_1772.method_27525(new class_2585(" ").method_10862(baseStyle));
	}

	public class_2583 getBase() {
		return baseStyle;
	}

	public void changeBaseStyle(class_2583 newStyle) {
		baseStyle = newStyle;
		for (SpanPartialState state : stateStack) {
			state.replaceBase(newStyle);
			newStyle = state.getCurrentStyle();
		}
	}

	public void color(class_5251 color) {
		modifyStyle(s -> s.method_27703(color));
	}

	public void baseColor() {
		color(baseStyle.method_10973());
	}

	@Override
	public void modifyStyle(UnaryOperator<class_2583> f) {
		stateStack.peek().addModification(f);
	}

	@Override
	public void pushStyle(class_2583 style) {
		stateStack.push(new SpanPartialState(style.method_27702(peekStyle()), style));
	}

	@Override
	public class_2583 popStyle() {
		if (stateStack.size() <= 1) {
			throw new IllegalStateException("Underflow in style stack");
		}
		return stateStack.pop().getCurrentStyle();
	}

	@Override
	public void reset() {
		endingExternal = isExternalLink;
		stateStack.clear();
		stateStack.push(new SpanPartialState(baseStyle, null));
		cluster = null;
		tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
		onClick = null;
		isExternalLink = false;
	}

	@Override
	public class_2583 peekStyle() {
		return stateStack.peek().getCurrentStyle();
	}

	// Represents the styling applied to a single stack frame.
	private static class SpanPartialState {
		// This is the current style of the frame.
		private class_2583 currentStyle;
		// This is null iff this frame represents the base state (i.e. nothing to merge),
		@Nullable private final class_2583 mergeStyle;
		// List of all the transformations that are applied to this frame.
		@Nullable private List<UnaryOperator<class_2583>> transformations = null;

		// Takes the current style state from downstream
		// and a style to merge onto it.
		public SpanPartialState(class_2583 currentStyle, class_2583 mergeStyle) {
			this.currentStyle = currentStyle;
			this.mergeStyle = mergeStyle;
		}

		public class_2583 getCurrentStyle() {
			return currentStyle;
		}

		public void addModification(UnaryOperator<class_2583> f) {
			if (transformations == null) {
				// We use a linked list because this list is likely to be very small
				// in order to skimp on space.
				transformations = new LinkedList<>();
			}
			transformations.add(f);
			this.currentStyle = f.apply(currentStyle);
		}

		public void replaceBase(class_2583 style) {
			if (mergeStyle != null) {
				style = mergeStyle.method_27702(style);
			}
			if (transformations != null) {
				for (UnaryOperator<class_2583> f : transformations) {
					style = f.apply(style);
				}
			}
			this.currentStyle = style;
		}
	}
}
