package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.EntityUtil;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_4587;

public class ComponentEntity extends TemplateComponent {

	@SerializedName("entity") public IVariable entityId;

	@SerializedName("render_size") float renderSize = 100;

	boolean rotate = true;
	@SerializedName("default_rotation") float defaultRotation = -45f;

	transient boolean errored;
	transient class_1297 entity;
	transient Function<class_1937, class_1297> creator;
	transient float renderScale, offset;

	@Override
	public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
		creator = EntityUtil.loadEntity(entityId.asString());
	}

	@Override
	public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
		loadEntity(page.mc.field_1687);
	}

	@Override
	public void render(class_4587 ms, BookPage page, int mouseX, int mouseY, float pticks) {
		if (errored) {
			page.fontRenderer.method_1720(ms, class_1074.method_4662("patchouli.gui.lexicon.loading_error"), x, y, 0xFF0000);
		}

		if (entity != null) {
			float rotation = rotate ? ClientTicker.total : defaultRotation;
			PageEntity.renderEntity(ms, entity, page.mc.field_1687, x, y, rotation, renderScale, offset);
		}
	}

	@Override
	public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
		super.onVariablesAvailable(lookup);
		entityId = lookup.apply(entityId);
	}

	private void loadEntity(class_1937 world) {
		if (!errored && (entity == null || !entity.method_5805())) {
			try {
				entity = creator.apply(world);
				float width = entity.method_17681();
				float height = entity.method_17682();

				float entitySize = Math.max(width, height);
				entitySize = Math.max(1F, entitySize);

				renderScale = renderSize / entitySize * 0.8F;
				offset = Math.max(height, entitySize) * 0.5F;
			} catch (Exception e) {
				errored = true;
				Patchouli.LOGGER.error("Failed to load entity", e);
			}
		}
	}

}
