package vazkii.patchouli.client.book.page;

import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.base.PersistentData.DataHolder.BookData;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.book.Book;

public class PageQuest extends PageWithText {

	class_2960 trigger;
	String title;

	transient boolean isManual;

	@Override
	public int getTextHeight() {
		return 22;
	}

	@Override
	public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
		super.build(entry, builder, pageNum);

		isManual = trigger == null;
	}

	public boolean isCompleted(Book book) {
		return isManual
				? PersistentData.data.getBookData(book).completedManualQuests.contains(entry.getId().toString())
				: trigger != null && ClientAdvancements.hasDone(trigger.toString());
	}

	@Override
	public void onDisplayed(GuiBookEntry parent, int left, int top) {
		super.onDisplayed(parent, left, top);

		if (isManual) {
			class_4185 button = new class_4185(GuiBook.PAGE_WIDTH / 2 - 50, GuiBook.PAGE_HEIGHT - 35, 100, 20, class_2585.field_24366, this::questButtonClicked);
			addButton(button);
			updateButtonText(button);
		}
	}

	private void updateButtonText(class_4185 button) {
		boolean completed = isCompleted(parent.book);
		class_2561 s = new class_2588(completed ? "patchouli.gui.lexicon.mark_incomplete" : "patchouli.gui.lexicon.mark_complete");
		button.method_25355(s);
	}

	protected void questButtonClicked(class_4185 button) {
		String res = entry.getId().toString();
		BookData data = PersistentData.data.getBookData(parent.book);

		if (data.completedManualQuests.contains(res)) {
			data.completedManualQuests.remove(res);
		} else {
			data.completedManualQuests.add(res);
		}
		PersistentData.save();

		updateButtonText(button);
		entry.markReadStateDirty();
	}

	@Override
	public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
		super.render(ms, mouseX, mouseY, pticks);

		parent.drawCenteredStringNoShadow(ms, title == null || title.isEmpty() ? class_1074.method_4662("patchouli.gui.lexicon.objective") : i18n(title), GuiBook.PAGE_WIDTH / 2, 0, book.headerColor);
		GuiBook.drawSeparator(ms, book, 0, 12);

		if (!isManual) {
			GuiBook.drawSeparator(ms, book, 0, GuiBook.PAGE_HEIGHT - 25);

			boolean completed = isCompleted(parent.book);
			String s = class_1074.method_4662(completed ? "patchouli.gui.lexicon.complete" : "patchouli.gui.lexicon.incomplete");
			int color = completed ? 0x008b1a : book.headerColor;

			parent.drawCenteredStringNoShadow(ms, s, GuiBook.PAGE_WIDTH / 2, GuiBook.PAGE_HEIGHT - 17, color);
		}

	}

}
