package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonEntry extends class_4185 {

	private static final int ANIM_TIME = 5;

	private final GuiBook parent;
	private final BookEntry entry;
	private float timeHovered;

	public GuiButtonEntry(GuiBook parent, int x, int y, BookEntry entry, class_4185.class_4241 onPress) {
		super(x, y, GuiBook.PAGE_WIDTH, 10, entry.getName(), onPress);
		this.parent = parent;
		this.entry = entry;
	}

	@Override
	public void method_25359(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
		if (field_22763) {
			if (method_25367()) {
				timeHovered = Math.min(ANIM_TIME, timeHovered + ClientTicker.delta);
			} else {
				timeHovered = Math.max(0, timeHovered - ClientTicker.delta);
			}

			float time = Math.max(0, Math.min(ANIM_TIME, timeHovered + (method_25367() ? partialTicks : -partialTicks)));
			float widthFract = time / ANIM_TIME;
			boolean locked = entry.isLocked();

			ms.method_22905(0.5F, 0.5F, 0.5F);
			class_332.method_25294(ms, field_22760 * 2, field_22761 * 2, (field_22760 + (int) ((float) field_22758 * widthFract)) * 2, (field_22761 + field_22759) * 2, 0x22000000);
			RenderSystem.enableBlend();

			if (locked) {
				RenderSystem.setShaderColor(1F, 1F, 1F, 0.7F);
				GuiBook.drawLock(ms, parent.book, field_22760 * 2 + 2, field_22761 * 2 + 2);
			} else {
				entry.getIcon().render(ms, field_22760 * 2 + 2, field_22761 * 2 + 2);
			}

			ms.method_22905(2F, 2F, 2F);

			class_5250 name;
			if (locked) {
				name = new class_2588("patchouli.gui.lexicon.locked");
			} else {
				name = entry.getName();
				if (entry.isPriority()) {
					name = name.method_27692(class_124.field_1056);
				}
			}

			name = name.method_27696(entry.getBook().getFontStyle());
			class_310.method_1551().field_1772.method_30883(ms, name, field_22760 + 12, field_22761, getColor());

			if (!entry.isLocked()) {
				GuiBook.drawMarking(ms, parent.book, field_22760 + field_22758 - 5, field_22761 + 1, entry.hashCode(), entry.getReadState());
			}
		}
	}

	private int getColor() {
		if (entry.isSecret()) {
			return 0xAA000000 | (parent.book.textColor & 0x00FFFFFF);
		}
		if (entry.isLocked()) {
			return 0x77000000 | (parent.book.textColor & 0x00FFFFFF);
		}
		return entry.getEntryColor();
	}

	@Override
	public void method_25354(class_1144 soundHandlerIn) {
		if (entry != null && !entry.isLocked()) {
			GuiBook.playBookFlipSound(parent.book);
		}
	}

	public BookEntry getEntry() {
		return entry;
	}

}
