package vazkii.patchouli.client.book.gui.button;

import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookMarkRead extends GuiButtonBook {

	private final Book book;

	public GuiButtonBookMarkRead(GuiBook parent, int x, int y) {
		super(parent, x, y, 308, 31, 11, 11, class_4185::method_25306, getTooltip(parent.book));
		this.book = parent.book;
	}

	@Override
	public void method_25359(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
		int px = field_22760 + 1;
		int py = (int) (field_22761 + 0.5);
		GuiBook.drawFromTexture(ms, book, field_22760, field_22761, 285, 160, 13, 10);
		GuiBook.drawFromTexture(ms, book, px, py, u, v, field_22758, field_22759);
		if (method_25367()) {
			GuiBook.drawFromTexture(ms, book, px, py, u + 11, v, field_22758, field_22759);
			parent.setTooltip(getTooltip());
		}
		parent.getMinecraft().field_1772.method_1720(ms, "+", px - 0.5F, py - 0.2F, 0x00FF01);
	}

	@Override
	public void method_25306() {
		for (BookEntry entry : this.book.getContents().entries.values()) {
			if (isMainPage(this.book)) {
				markEntry(entry);
			} else {
				markCategoryAsRead(entry, entry.getCategory(), this.book.getContents().entries.size());
			}
		}
	}

	private void markCategoryAsRead(BookEntry entry, BookCategory category, int maxRecursion) {
		if (category.getName().equals(this.book.getContents().getCurrentGui().method_25440())) {
			markEntry(entry);
		} else if (!category.isRootCategory() && maxRecursion > 0) {
			markCategoryAsRead(entry, entry.getCategory().getParentCategory(), maxRecursion - 1);
		}
	}

	private void markEntry(BookEntry entry) {
		boolean dirty = false;
		String key = entry.getId().toString();

		if (!entry.isLocked() && entry.getReadState().equals(EntryDisplayState.UNREAD)) {
			PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(book);

			if (!data.viewedEntries.contains(key)) {
				data.viewedEntries.add(key);
				dirty = true;
				entry.markReadStateDirty();
			}
		}

		if (dirty) {
			PersistentData.save();
		}
	}

	private static class_2561 getTooltip(Book book) {
		String text = isMainPage(book) ? "patchouli.gui.lexicon.button.mark_all_read" : "patchouli.gui.lexicon.button.mark_category_read";
		return new class_2588(text);
	}

	private static boolean isMainPage(Book book) {
		return !book.getContents().currentGui.canSeeBackButton();
	}
}
