package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.glfw.GLFW;

import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public abstract class GuiBookEntryList extends GuiBook {

	public static final int ENTRIES_PER_PAGE = 13;
	public static final int ENTRIES_IN_FIRST_PAGE = 11;

	BookTextRenderer text;

	final List<class_4185> entryButtons = new ArrayList<>();
	List<BookEntry> allEntries;
	final List<BookEntry> visibleEntries = new ArrayList<>();

	class_342 searchField;

	public GuiBookEntryList(Book book, class_2561 title) {
		super(book, title);
	}

	@Override
	public void method_25426() {
		super.method_25426();

		text = new BookTextRenderer(this, new class_2585(getDescriptionText()), LEFT_PAGE_X, TOP_PADDING + 22);

		allEntries = new ArrayList<>(getEntries());
		allEntries.removeIf(BookEntry::shouldHide);
		if (shouldSortEntryList()) {
			Collections.sort(allEntries);
		}

		this.searchField = createSearchBar();
		buildEntryButtons();
	}

	protected class_342 createSearchBar() {
		class_342 field = new class_342(field_22793, 160, 170, 90, 12, class_2585.field_24366);
		field.method_1880(32);
		//field.setHasBorder(false);
		field.method_1856(false);
		field.method_25407(true);
		return field;
	}

	protected abstract String getDescriptionText();
	protected abstract Collection<BookEntry> getEntries();

	protected boolean doesEntryCountForProgress(BookEntry entry) {
		return true;
	}

	protected boolean shouldDrawProgressBar() {
		return true;
	}

	protected boolean shouldSortEntryList() {
		return true;
	}

	protected void addSubcategoryButtons() {
		// NO-OP
	}

	@Override
	void drawForegroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
		super.drawForegroundElements(ms, mouseX, mouseY, partialTicks);

		if (spread == 0) {
			drawCenteredStringNoShadow(ms, method_25440().method_30937(), LEFT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);
			drawCenteredStringNoShadow(ms, getChapterListTitle(), RIGHT_PAGE_X + PAGE_WIDTH / 2, TOP_PADDING, book.headerColor);

			drawSeparator(ms, book, LEFT_PAGE_X, TOP_PADDING + 12);
			drawSeparator(ms, book, RIGHT_PAGE_X, TOP_PADDING + 12);

			text.render(ms, mouseX, mouseY);
			if (shouldDrawProgressBar()) {
				drawProgressBar(ms, book, mouseX, mouseY, this::doesEntryCountForProgress);
			}
		} else if (spread % 2 == 1 && spread == maxSpreads - 1 && entryButtons.size() <= ENTRIES_PER_PAGE) {
			drawPageFiller(ms, book);
		}

		if (!searchField.method_1882().isEmpty()) {
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			drawFromTexture(ms, book, searchField.field_22760 - 8, searchField.field_22761, 140, 183, 99, 14);
			class_2561 toDraw = new class_2585(searchField.method_1882()).method_10862(book.getFontStyle());
			field_22793.method_30883(ms, toDraw, searchField.field_22760 + 7, searchField.field_22761 + 1, 0);
		}

		if (visibleEntries.isEmpty()) {
			if (!searchField.method_1882().isEmpty()) {
				drawCenteredStringNoShadow(ms, class_1074.method_4662("patchouli.gui.lexicon.no_results"), GuiBook.RIGHT_PAGE_X + GuiBook.PAGE_WIDTH / 2, 80, 0x333333);
				ms.method_22905(2F, 2F, 2F);
				drawCenteredStringNoShadow(ms, class_1074.method_4662("patchouli.gui.lexicon.sad"), GuiBook.RIGHT_PAGE_X / 2 + GuiBook.PAGE_WIDTH / 4, 47, 0x999999);
				ms.method_22905(0.5F, 0.5F, 0.5F);
			} else {
				drawCenteredStringNoShadow(ms, getNoEntryMessage(), GuiBook.RIGHT_PAGE_X + GuiBook.PAGE_WIDTH / 2, 80, 0x333333);
			}
		}
	}

	protected String getChapterListTitle() {
		return class_1074.method_4662("patchouli.gui.lexicon.chapters");
	}

	protected String getNoEntryMessage() {
		return class_1074.method_4662("patchouli.gui.lexicon.no_entries");
	}

	@Override
	public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
		return text.click(mouseX, mouseY, mouseButton)
				|| searchField.method_25402(mouseX - bookLeft, mouseY - bookTop, mouseButton)
				|| super.mouseClickedScaled(mouseX, mouseY, mouseButton);
	}

	@Override
	public boolean method_25400(char c, int i) {
		String currQuery = searchField.method_1882();
		if (searchField.method_25400(c, i)) {
			if (!searchField.method_1882().equals(currQuery)) {
				buildEntryButtons();
			}

			return true;
		}

		return super.method_25400(c, i);
	}

	@Override
	public boolean method_25404(int key, int scanCode, int modifiers) {
		String currQuery = searchField.method_1882();

		if (key == GLFW.GLFW_KEY_ENTER) {
			if (visibleEntries.size() == 1) {
				displayLexiconGui(new GuiBookEntry(book, visibleEntries.get(0)), true);
				return true;
			}
		} else if (searchField.method_25404(key, scanCode, modifiers)) {
			if (!searchField.method_1882().equals(currQuery)) {
				buildEntryButtons();
			}

			return true;
		}

		return super.method_25404(key, scanCode, modifiers);
	}

	public void handleButtonCategory(class_4185 button) {
		displayLexiconGui(new GuiBookCategory(book, ((GuiButtonCategory) button).getCategory()), true);
	}

	public void handleButtonEntry(class_4185 button) {
		GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry) button).getEntry());
	}

	@Override
	void onPageChanged() {
		buildEntryButtons();
	}

	void buildEntryButtons() {
		removeDrawablesIn(entryButtons);
		entryButtons.clear();
		visibleEntries.clear();

		String query = searchField.method_1882().toLowerCase();
		allEntries.stream().filter((e) -> e.isFoundByQuery(query)).forEach(visibleEntries::add);

		maxSpreads = 1;
		int count = visibleEntries.size();
		count -= ENTRIES_IN_FIRST_PAGE;
		if (count > 0) {
			maxSpreads += (int) Math.ceil((float) count / (ENTRIES_PER_PAGE * 2));
		}

		while (getEntryCountStart() > visibleEntries.size()) {
			spread--;
		}

		if (spread == 0) {
			addEntryButtons(RIGHT_PAGE_X, TOP_PADDING + 20, 0, ENTRIES_IN_FIRST_PAGE);
			addSubcategoryButtons();
		} else {
			int start = getEntryCountStart();
			addEntryButtons(LEFT_PAGE_X, TOP_PADDING, start, ENTRIES_PER_PAGE);
			addEntryButtons(RIGHT_PAGE_X, TOP_PADDING, start + ENTRIES_PER_PAGE, ENTRIES_PER_PAGE);
		}
	}

	int getEntryCountStart() {
		if (spread == 0) {
			return 0;
		}

		int start = ENTRIES_IN_FIRST_PAGE;
		start += (ENTRIES_PER_PAGE * 2) * (spread - 1);
		return start;
	}

	void addEntryButtons(int x, int y, int start, int count) {
		for (int i = 0; i < count && (i + start) < visibleEntries.size(); i++) {
			class_4185 button = new GuiButtonEntry(this, bookLeft + x, bookTop + y + i * 11, visibleEntries.get(start + i), this::handleButtonEntry);
			method_37063(button);
			entryButtons.add(button);
		}
	}

	public String getSearchQuery() {
		return searchField.method_1882();
	}

}
