package vazkii.patchouli.client.book.gui;

import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5251;

public class BookTextRenderer {
	private final Book book;
	private final GuiBook gui;
	private final class_2561 text;
	private final int x, y, width;
	private final int lineHeight;
	private final class_2583 baseStyle;

	private List<Word> words;
	private float scale;

	public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y) {
		this(gui, text, x, y, GuiBook.PAGE_WIDTH, GuiBook.TEXT_LINE_HEIGHT, gui.book.textColor);
	}

	public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y, int width, int lineHeight, int baseColor) {
		this.book = gui.book;
		this.gui = gui;
		if (book.i18n && text instanceof class_2585) {
			this.text = new class_2585(class_1074.method_4662(((class_2585) text).method_10993()));
		} else {
			this.text = text;
		}
		this.x = x;
		this.y = y;
		this.width = width;
		this.lineHeight = lineHeight;
		this.baseStyle = book.getFontStyle().method_27703(class_5251.method_27717(baseColor));

		build();
	}

	private void build() {
		BookTextParser parser = new BookTextParser(gui, book, x, y, width, lineHeight, baseStyle);
		TextLayouter layouter = new TextLayouter(gui, x, y, lineHeight, width, PatchouliConfig.overflowMode.getValue());
		layouter.layout(class_310.method_1551().field_1772, parser.parse(text));
		scale = layouter.getScale();
		words = layouter.getWords();
	}

	private double rescale(double in, double origin) {
		return origin + (in - origin) / scale;
	}

	public void render(class_4587 ms, int mouseX, int mouseY) {
		if (!words.isEmpty()) {
			class_327 font = class_310.method_1551().field_1772;
			class_2583 style = book.getFontStyle();
			Word first = words.get(0);
			ms.method_22903();
			ms.method_22904(first.x, first.y, 0);
			ms.method_22905(scale, scale, 1.0f);
			ms.method_22904(-first.x, -first.y, 0);
			int scaledX = (int) rescale(mouseX, first.x);
			int scaledY = (int) rescale(mouseY, first.y);
			words.forEach(word -> word.render(ms, font, style, scaledX, scaledY));
			ms.method_22909();
		}
	}

	public boolean click(double mouseX, double mouseY, int mouseButton) {
		if (!words.isEmpty()) {
			Word first = words.get(0);
			double scaledX = rescale(mouseX, first.x);
			double scaledY = rescale(mouseY, first.y);
			for (Word word : words) {
				if (word.click(scaledX, scaledY, mouseButton)) {
					return true;
				}
			}
		}

		return false;
	}
}
