package vazkii.patchouli.client.book;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookIcon {
	private static final BookIcon EMPTY = new BookIcon(class_1799.field_8037);

	private final IconType type;
	private final class_1799 stack;
	private final class_2960 res;

	public static BookIcon from(String str) {
		if (str.endsWith(".png")) {
			return new BookIcon(new class_2960(str));
		} else {
			try {
				class_1799 stack = ItemStackUtil.loadStackFromString(str);
				return new BookIcon(stack);
			} catch (Exception e) {
				Patchouli.LOGGER.warn("Invalid icon item stack: {}", e.getMessage());
				return EMPTY;
			}
		}
	}

	public BookIcon(class_1799 stack) {
		type = IconType.STACK;
		this.stack = stack;
		res = null;
	}

	public BookIcon(class_2960 res) {
		type = IconType.RESOURCE;
		stack = null;
		this.res = res;
	}

	public void render(class_4587 ms, int x, int y) {
		switch (type) {
		case STACK:
			RenderHelper.renderItemStackInGui(ms, stack, x, y);
			break;

		case RESOURCE:
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, res);
			class_332.method_25290(ms, x, y, 0, 0, 16, 16, 16, 16);
			break;
		}
	}

	private enum IconType {
		STACK, RESOURCE
	}

}
