package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.Nullable;

import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public final class BookContentResourceLoader implements BookContentLoader {
	public static final BookContentResourceLoader INSTANCE = new BookContentResourceLoader();

	private BookContentResourceLoader() {}

	@Override
	public void findFiles(Book book, String dir, List<class_2960> list) {
		String prefix = String.format("%s/%s/%s/%s", BookRegistry.BOOKS_LOCATION, book.id.method_12832(), BookContentsBuilder.DEFAULT_LANG, dir);
		Collection<class_2960> files = class_310.method_1551().method_1478().method_14488(prefix, p -> p.endsWith(".json"));

		files.stream()
				.distinct()
				.filter(file -> file.method_12836().equals(book.id.method_12836()))
				.map(file -> {
					// caller expects list to contain logical id's, not file paths.
					// we end up going from path -> id -> back to path, but it's okay as a transitional measure
					Preconditions.checkArgument(file.method_12832().startsWith(prefix));
					Preconditions.checkArgument(file.method_12832().endsWith(".json"));
					String newPath = file.method_12832().substring(prefix.length(), file.method_12832().length() - ".json".length());
					// Vanilla expects `prefix` above to not have a trailing slash, so we
					// have to remove it ourselves from the path
					if (newPath.startsWith("/")) {
						newPath = newPath.substring(1);
					}
					return new class_2960(file.method_12836(), newPath);
				})
				.forEach(list::add);
	}

	@Nullable
	@Override
	public InputStream loadJson(Book book, class_2960 file, @Nullable class_2960 fallback) {
		Patchouli.LOGGER.debug("Loading {}", file);
		class_3300 manager = class_310.method_1551().method_1478();
		try {
			if (manager.method_18234(file)) {
				return manager.method_14486(file).method_14482();
			} else if (fallback != null && manager.method_18234(fallback)) {
				return manager.method_14486(fallback).method_14482();
			} else {
				return null;
			}
		} catch (IOException ex) {
			throw new UncheckedIOException(ex);
		}
	}
}
