package vazkii.patchouli.client.book;

import org.apache.commons.io.FilenameUtils;

import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.class_2960;

public final class BookContentExternalLoader implements BookContentLoader {
	public static final BookContentExternalLoader INSTANCE = new BookContentExternalLoader();

	private BookContentExternalLoader() {}

	@Override
	public void findFiles(Book book, String dir, List<class_2960> list) {
		File root = new File(BookFolderLoader.loadDir, book.id.method_12832());
		File enUs = new File(root, BookContentsBuilder.DEFAULT_LANG);
		if (enUs.exists()) {
			File searchDir = new File(enUs, dir);
			if (searchDir.exists()) {
				crawl(searchDir, searchDir, list);
			}
		}
	}

	private void crawl(File realRoot, File root, List<class_2960> list) {
		File[] files = root.listFiles();
		for (File f : files) {
			if (f.isDirectory()) {
				crawl(realRoot, f, list);
			} else if (f.getName().endsWith(".json")) {
				list.add(relativize(realRoot, f));
			}
		}
	}

	private class_2960 relativize(File root, File f) {
		String rootPath = root.getAbsolutePath();
		String filePath = f.getAbsolutePath().substring(rootPath.length() + 1);
		String cleanPath = FilenameUtils.removeExtension(FilenameUtils.separatorsToUnix(filePath));

		return new class_2960(Patchouli.MOD_ID, cleanPath);
	}

	@Override
	public InputStream loadJson(Book book, class_2960 resloc, class_2960 fallback) {
		String realPath = resloc.method_12832().substring(BookFolderLoader.loadDir.getName().length());
		File targetFile = new File(BookFolderLoader.loadDir, realPath);

		if (targetFile.exists()) {
			FileInputStream stream;
			try {
				stream = new FileInputStream(targetFile);
				return stream;
			} catch (IOException e) {
				if (fallback != null) {
					Patchouli.LOGGER.debug("Failed to load {}. Switching to fallback. ({})", resloc, e.getMessage());
					return loadJson(book, fallback, null);
				} else {
					Patchouli.LOGGER.warn("Failed to load {}.", resloc, e);
					return null;
				}
			}
		}

		return null;
	}

}
