/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.api;

import com.google.common.base.Suppliers;
import java.io.InputStream;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.IStyleStack;
import vazkii.patchouli.api.stub.StubPatchouliAPI;

public class PatchouliAPI {
    private static final Supplier<IPatchouliAPI> LAZY_INSTANCE = Suppliers.memoize(() -> {
        try {
            return (IPatchouliAPI)Class.forName("vazkii.patchouli.common.base.PatchouliAPIImpl").newInstance();
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find PatchouliAPIImpl, using a dummy");
            return StubPatchouliAPI.INSTANCE;
        }
    });

    public static IPatchouliAPI get() {
        return LAZY_INSTANCE.get();
    }

    public static interface IPatchouliAPI {
        public boolean isStub();

        public void setConfigFlag(String var1, boolean var2);

        public boolean getConfigFlag(String var1);

        public void openBookGUI(ServerPlayer var1, ResourceLocation var2);

        public void openBookEntry(ServerPlayer var1, ResourceLocation var2, ResourceLocation var3, int var4);

        public void openBookGUI(ResourceLocation var1);

        public void openBookEntry(ResourceLocation var1, ResourceLocation var2, int var3);

        public ResourceLocation getOpenBookGui();

        public Component getSubtitle(ResourceLocation var1);

        public ItemStack getBookStack(ResourceLocation var1);

        @Environment(value=EnvType.CLIENT)
        public void registerTemplateAsBuiltin(ResourceLocation var1, Supplier<InputStream> var2);

        @Environment(value=EnvType.CLIENT)
        public void registerCommand(String var1, Function<IStyleStack, String> var2);

        @Environment(value=EnvType.CLIENT)
        public void registerFunction(String var1, BiFunction<String, IStyleStack, String> var2);

        public IMultiblock getMultiblock(ResourceLocation var1);

        public IMultiblock registerMultiblock(ResourceLocation var1, IMultiblock var2);

        @Nullable
        public IMultiblock getCurrentMultiblock();

        public void showMultiblock(IMultiblock var1, Component var2, BlockPos var3, Rotation var4);

        public void clearMultiblock();

        public IMultiblock makeMultiblock(String[][] var1, Object ... var2);

        public IMultiblock makeSparseMultiblock(Map<BlockPos, IStateMatcher> var1);

        public IStateMatcher predicateMatcher(BlockState var1, Predicate<BlockState> var2);

        public IStateMatcher predicateMatcher(Block var1, Predicate<BlockState> var2);

        public IStateMatcher stateMatcher(BlockState var1);

        public IStateMatcher propertyMatcher(BlockState var1, Property<?> ... var2);

        public IStateMatcher looseBlockMatcher(Block var1);

        public IStateMatcher strictBlockMatcher(Block var1);

        public IStateMatcher displayOnlyMatcher(BlockState var1);

        public IStateMatcher displayOnlyMatcher(Block var1);

        public IStateMatcher airMatcher();

        public IStateMatcher anyMatcher();
    }
}

