/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IVariable;

public final class SerializationUtil {
    public static final IVariable.Serializer VARIABLE_SERIALIZER = new IVariable.Serializer();
    public static final Gson RAW_GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(IVariable.class, (Object)VARIABLE_SERIALIZER).create();
    public static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();

    private SerializationUtil() {
    }

    public static ResourceLocation getAsResourceLocation(JsonObject object, String key, @Nullable ResourceLocation fallback) {
        if (object.has(key)) {
            return ResourceLocation.tryParse((String)GsonHelper.convertToString((JsonElement)object.get(key), (String)key));
        }
        return fallback;
    }

    @Nullable
    public static <T extends Enum<T>> T getAsEnum(JsonObject object, String key, Class<T> clz, @Nullable T fallback) {
        if (object.has(key)) {
            String str = GsonHelper.convertToString((JsonElement)object.get(key), (String)key).toUpperCase(Locale.ROOT);
            return Enum.valueOf(clz, str);
        }
        return fallback;
    }
}

