/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookMarkRead
extends GuiButtonBook {
    private final Book book;

    public GuiButtonBookMarkRead(GuiBook parent, int x, int y) {
        super(parent, x, y, 308, 31, 11, 11, Button::onPress, GuiButtonBookMarkRead.getTooltip(parent.book));
        this.book = parent.book;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int px = this.getX() + 1;
        int py = (int)((double)this.getY() + 0.5);
        GuiBook.drawFromTexture(graphics, this.book, this.getX(), this.getY(), 285, 160, 13, 10);
        GuiBook.drawFromTexture(graphics, this.book, px, py, this.u, this.v, this.width, this.height);
        if (this.isHoveredOrFocused()) {
            GuiBook.drawFromTexture(graphics, this.book, px, py, this.u + 11, this.v, this.width, this.height);
            this.parent.setTooltip(this.getTooltipLines());
        }
        graphics.drawString(this.parent.getMinecraft().font, "+", px, py, 65281, true);
    }

    public void onPress() {
        for (BookEntry entry : this.book.getContents().entries.values()) {
            if (GuiButtonBookMarkRead.isMainPage(this.book)) {
                this.markEntry(entry);
                continue;
            }
            this.markCategoryAsRead(entry, entry.getCategory(), this.book.getContents().entries.size());
        }
    }

    private void markCategoryAsRead(BookEntry entry, BookCategory category, int maxRecursion) {
        if (category.getName().equals((Object)this.book.getContents().getCurrentGui().getTitle())) {
            this.markEntry(entry);
        } else if (!category.isRootCategory() && maxRecursion > 0) {
            this.markCategoryAsRead(entry, entry.getCategory().getParentCategory(), maxRecursion - 1);
        }
    }

    private void markEntry(BookEntry entry) {
        boolean dirty = false;
        ResourceLocation key = entry.getId();
        if (!entry.isLocked() && entry.getReadState().equals((Object)EntryDisplayState.UNREAD)) {
            PersistentData.BookData data = PersistentData.data.getBookData(this.book);
            if (!data.viewedEntries.contains(key)) {
                data.viewedEntries.add(key);
                dirty = true;
                entry.markReadStateDirty();
            }
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    private static Component getTooltip(Book book) {
        String text = GuiButtonBookMarkRead.isMainPage(book) ? "patchouli.gui.lexicon.button.mark_all_read" : "patchouli.gui.lexicon.button.mark_category_read";
        return Component.translatable((String)text);
    }

    private static boolean isMainPage(Book book) {
        return !book.getContents().currentGui.canSeeBackButton();
    }
}

