/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliDataComponents;
import vazkii.patchouli.common.item.PatchouliItems;

public class ItemModBook
extends Item {
    public ItemModBook() {
        super(new Item.Properties().stacksTo(1));
    }

    public static float getCompletion(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        float progression = 0.0f;
        if (book != null) {
            int totalEntries = 0;
            int unlockedEntries = 0;
            for (BookEntry entry : book.getContents().entries.values()) {
                if (entry.isSecret()) continue;
                ++totalEntries;
                if (entry.isLocked()) continue;
                ++unlockedEntries;
            }
            progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        }
        return progression;
    }

    public static ItemStack forBook(Book book) {
        return ItemModBook.forBook(book.id);
    }

    public static ItemStack forBook(ResourceLocation book) {
        ItemStack stack = new ItemStack((ItemLike)PatchouliItems.BOOK);
        stack.set(PatchouliDataComponents.BOOK, (Object)book);
        return stack;
    }

    public String getCreatorModId(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return book.owner.getId();
        }
        return BuiltInRegistries.ITEM.getKey((Object)this).getNamespace();
    }

    public static Book getBook(ItemStack stack) {
        ResourceLocation res = ItemModBook.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookRegistry.INSTANCE.books.get(res);
    }

    private static ResourceLocation getBookId(ItemStack stack) {
        if (!stack.has(PatchouliDataComponents.BOOK)) {
            return null;
        }
        return (ResourceLocation)stack.get(PatchouliDataComponents.BOOK);
    }

    public Component getName(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return Component.translatable((String)book.name);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        Book book;
        super.appendHoverText(stack, context, tooltip, flagIn);
        ResourceLocation rl = ItemModBook.getBookId(stack);
        if (flagIn.isAdvanced()) {
            tooltip.add((Component)Component.literal((String)("Book ID: " + String.valueOf(rl))).withStyle(ChatFormatting.GRAY));
        }
        if ((book = ItemModBook.getBook(stack)) != null && !book.getContents().isErrored()) {
            tooltip.add((Component)book.getSubtitle().withStyle(ChatFormatting.GRAY));
        } else if (book == null) {
            if (rl == null) {
                tooltip.add((Component)Component.translatable((String)"item.patchouli.guide_book.undefined").withStyle(ChatFormatting.DARK_GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.patchouli.guide_book.invalid", (Object[])new Object[]{rl}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        Book book = ItemModBook.getBook(stack);
        if (book == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (playerIn instanceof ServerPlayer) {
            PatchouliAPI.get().openBookGUI((ServerPlayer)playerIn, book.id);
            SoundEvent sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.BOOK_OPEN);
            playerIn.playSound(sfx, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

