/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookOpenTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"open_book");
    public static final BookOpenTrigger INSTANCE = new BookOpenTrigger();

    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(@NotNull ServerPlayer player, @NotNull ResourceLocation book) {
        this.trigger(player, instance -> instance.matches(book, null, 0));
    }

    public void trigger(@NotNull ServerPlayer player, @NotNull ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        this.trigger(player, instance -> instance.matches(book, entry, page));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, ResourceLocation book, Optional<ResourceLocation> entry, MinMaxBounds.Ints page) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceLocation.CODEC.fieldOf("book").forGetter(TriggerInstance::book), (App)ResourceLocation.CODEC.optionalFieldOf("entry").forGetter(TriggerInstance::entry), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("page", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::page)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(@NotNull ResourceLocation book, @Nullable ResourceLocation entry, int page) {
            return this.book.equals((Object)book) && (this.entry.isEmpty() || this.entry.get().equals((Object)entry)) && this.page.matches(page);
        }
    }
}

