/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.jei;

import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.item.PatchouliDataComponents;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.mixin.client.AccessorKeyMapping;

@JeiPlugin
public class PatchouliJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"patchouli");
    private static final KeyMapping showRecipe;
    private static final KeyMapping showUses;
    private static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)PatchouliItems.BOOK, (stack, context) -> {
            if (!stack.has(PatchouliDataComponents.BOOK)) {
                return "";
            }
            return ((ResourceLocation)stack.get(PatchouliDataComponents.BOOK)).toString();
        });
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        PatchouliJeiPlugin.jeiRuntime = jeiRuntime;
    }

    public static boolean handleRecipeKeybind(int keyCode, int scanCode, ItemStack stack) {
        if (showRecipe != null && showRecipe.matches(keyCode, scanCode)) {
            IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            jeiRuntime.getRecipesGui().show(focus);
            return true;
        }
        if (showUses != null && showUses.matches(keyCode, scanCode)) {
            IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            jeiRuntime.getRecipesGui().show(focus);
            return true;
        }
        return false;
    }

    static {
        Map<String, KeyMapping> allKeyMappings = AccessorKeyMapping.getAllKeyMappings();
        showRecipe = allKeyMappings.get("key.jei.showRecipe");
        showUses = allKeyMappings.get("key.jei.showUses");
        if (showRecipe == null || showUses == null) {
            PatchouliAPI.LOGGER.warn("Could not locate JEI keybindings, lookups in books may not work");
        }
    }
}

