/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.variable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import vazkii.patchouli.api.IVariableSerializer;

public class GenericArrayVariableSerializer<T>
implements IVariableSerializer<T[]> {
    protected final T[] empty;
    private final IVariableSerializer<T> inner;

    public GenericArrayVariableSerializer(IVariableSerializer<T> inner, Class<T> type) {
        this.empty = (Object[])Array.newInstance(type, 0);
        this.inner = inner;
    }

    @Override
    public T[] fromJson(JsonElement json, HolderLookup.Provider registries) {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList<T> stacks = new ArrayList<T>();
            for (JsonElement e : array) {
                stacks.add(this.inner.fromJson(e, registries));
            }
            return stacks.toArray(this.empty);
        }
        throw new IllegalArgumentException("Can't create an array of objects from a non-array JSON!");
    }

    public JsonArray toJson(T[] array, HolderLookup.Provider registries) {
        JsonArray result = new JsonArray();
        for (T elem : array) {
            result.add(this.inner.toJson(elem, registries));
        }
        return result;
    }
}

