/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page.abstr;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipe;

public abstract class PageDoubleRecipeRegistry<T extends Recipe<?>>
extends PageDoubleRecipe<T> {
    private final RecipeType<? extends T> recipeType;

    public PageDoubleRecipeRegistry(RecipeType<? extends T> recipeType) {
        this.recipeType = recipeType;
    }

    @Nullable
    private T getRecipe(Level level, ResourceLocation id) {
        RecipeManager manager = level.getRecipeManager();
        RecipeHolder recipeHolder = manager.byKey(id).filter(recipe -> recipe.value().getType() == this.recipeType).orElse(null);
        return (T)(recipeHolder != null ? recipeHolder.value() : null);
    }

    @Override
    protected T loadRecipe(Level level, BookContentsBuilder builder, BookEntry entry, ResourceLocation res, boolean linkRecipe) {
        if (res == null || level == null) {
            return null;
        }
        T tempRecipe = this.getRecipe(level, res);
        if (tempRecipe == null) {
            tempRecipe = this.getRecipe(level, ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)res.getPath()));
        }
        if (tempRecipe != null) {
            if (linkRecipe) {
                entry.addRelevantStack(builder, tempRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()), this.pageNum);
            }
            return tempRecipe;
        }
        PatchouliAPI.LOGGER.warn("Recipe {} (of type {}) not found", (Object)res, (Object)BuiltInRegistries.RECIPE_TYPE.getKey(this.recipeType));
        return null;
    }
}

