/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.api.PatchouliAPI;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static String getEntityName(String entityId) {
        Pair<String, String> nameAndNbt = EntityUtil.splitNameAndNBT(entityId);
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation((String)nameAndNbt.getLeft()));
        return type.getDescriptionId();
    }

    public static Function<Level, Entity> loadEntity(String entityId) {
        ResourceLocation key;
        Optional maybeType;
        Pair<String, String> nameAndNbt = EntityUtil.splitNameAndNBT(entityId);
        entityId = (String)nameAndNbt.getLeft();
        String nbtStr = (String)nameAndNbt.getRight();
        CompoundTag nbt = null;
        if (!nbtStr.isEmpty()) {
            try {
                nbt = TagParser.parseTag((String)nbtStr);
            }
            catch (CommandSyntaxException e) {
                PatchouliAPI.LOGGER.error("Failed to load entity data", (Throwable)e);
            }
        }
        if ((maybeType = BuiltInRegistries.ENTITY_TYPE.getOptional(key = new ResourceLocation(entityId))).isEmpty()) {
            throw new RuntimeException("Unknown entity id: " + entityId);
        }
        EntityType type = (EntityType)maybeType.get();
        CompoundTag useNbt = nbt;
        String useId = entityId;
        return world -> {
            try {
                Entity entity = type.create(world);
                if (useNbt != null) {
                    entity.load(useNbt);
                }
                return entity;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't load entity " + useId, e);
            }
        };
    }

    private static Pair<String, String> splitNameAndNBT(String entityId) {
        int nbtStart = entityId.indexOf("{");
        String nbtStr = "";
        if (nbtStart > 0) {
            nbtStr = entityId.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            entityId = entityId.substring(0, nbtStart);
        }
        return Pair.of((Object)entityId, (Object)nbtStr);
    }
}

