/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonEntry
extends Button {
    private static final int ANIM_TIME = 5;
    private final GuiBook parent;
    private final BookEntry entry;
    private float timeHovered;

    public GuiButtonEntry(GuiBook parent, int x, int y, BookEntry entry, Button.OnPress onPress) {
        super(x, y, 116, 10, (Component)entry.getName(), onPress, DEFAULT_NARRATION);
        this.parent = parent;
        this.entry = entry;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent name;
        if (!this.active) {
            return;
        }
        this.timeHovered = this.isHoveredOrFocused() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
        float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.isHoveredOrFocused() ? partialTicks : -partialTicks)));
        float widthFract = time / 5.0f;
        boolean locked = this.entry.isLocked();
        graphics.pose().scale(0.5f, 0.5f, 0.5f);
        graphics.fill(this.getX() * 2, this.getY() * 2, (this.getX() + (int)((float)this.width * widthFract)) * 2, (this.getY() + this.height) * 2, 0x22000000);
        RenderSystem.enableBlend();
        if (locked) {
            graphics.setColor(1.0f, 1.0f, 1.0f, 0.7f);
            GuiBook.drawLock(graphics, this.parent.book, this.getX() * 2 + 2, this.getY() * 2 + 2);
        } else {
            this.entry.getIcon().render(graphics, this.getX() * 2 + 2, this.getY() * 2 + 2);
        }
        graphics.pose().scale(2.0f, 2.0f, 2.0f);
        if (locked) {
            name = Component.translatable((String)"patchouli.gui.lexicon.locked");
        } else {
            name = this.entry.getName();
            if (this.entry.isPriority()) {
                name = name.withStyle(ChatFormatting.ITALIC);
            }
        }
        name = name.withStyle(this.entry.getBook().getFontStyle());
        graphics.drawString(Minecraft.getInstance().font, (Component)name, this.getX() + 12, this.getY(), this.getColor(), false);
        if (!this.entry.isLocked()) {
            GuiBook.drawMarking(graphics, this.parent.book, this.getX() + this.width - 5, this.getY() + 1, this.entry.hashCode(), this.entry.getReadState());
        }
    }

    private int getColor() {
        if (this.entry.isSecret()) {
            return 0xAA000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        if (this.entry.isLocked()) {
            return 0x77000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        return this.entry.getEntryColor();
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        if (this.entry != null && !this.entry.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }
}

