/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonCategory
extends Button {
    private static final int ANIM_TIME = 5;
    private final GuiBook parent;
    @Nullable
    private BookCategory category;
    private final BookIcon icon;
    private final Component name;
    private final int u;
    private final int v;
    private float timeHovered;

    public GuiButtonCategory(GuiBook parent, int x, int y, BookCategory category, Button.OnPress onPress) {
        this(parent, x, y, category.getIcon(), (Component)category.getName(), onPress);
        this.category = category;
    }

    public GuiButtonCategory(GuiBook parent, int x, int y, BookIcon icon, Component name, Button.OnPress onPress) {
        super(parent.bookLeft + x, parent.bookTop + y, 20, 20, name, onPress, DEFAULT_NARRATION);
        this.parent = parent;
        this.u = x;
        this.v = y;
        this.icon = icon;
        this.name = name;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.active) {
            boolean locked;
            this.timeHovered = this.isHoveredOrFocused() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.isHoveredOrFocused() ? partialTicks : -partialTicks)));
            float transparency = 0.5f - time / 5.0f * 0.5f;
            boolean bl = locked = this.category != null && this.category.isLocked();
            if (locked) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(graphics, this.parent.book, this.getX() + 2, this.getY() + 2);
            } else {
                this.icon.render(graphics, this.getX() + 2, this.getY() + 2);
            }
            graphics.pose().pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            GuiBook.drawFromTexture(graphics, this.parent.book, this.getX(), this.getY(), this.u, this.v, this.width, this.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.category != null && !this.category.isLocked()) {
                GuiBook.drawMarking(graphics, this.parent.book, this.getX(), this.getY(), 0, this.category.getReadState());
            }
            graphics.pose().popPose();
            if (this.isHoveredOrFocused()) {
                this.parent.setTooltip(new Component[]{locked ? Component.translatable((String)"patchouli.gui.lexicon.locked").withStyle(ChatFormatting.GRAY) : this.name});
            }
        }
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        if (this.category != null && !this.category.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookCategory getCategory() {
        return this.category;
    }
}

