/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonBook
extends Button {
    protected final GuiBook parent;
    protected final int u;
    protected final int v;
    private final Supplier<Boolean> displayCondition;
    protected final List<Component> tooltip;

    public GuiButtonBook(GuiBook parent, int x, int y, int u, int v, int w, int h, Button.OnPress onPress, Component ... tooltip) {
        this(parent, x, y, u, v, w, h, () -> true, onPress, tooltip);
    }

    public GuiButtonBook(GuiBook parent, int x, int y, int u, int v, int w, int h, Supplier<Boolean> displayCondition, Button.OnPress onPress, Component ... tooltip) {
        super(x, y, w, h, tooltip[0], onPress, DEFAULT_NARRATION);
        this.parent = parent;
        this.u = u;
        this.v = v;
        this.displayCondition = displayCondition;
        this.tooltip = Arrays.asList(tooltip);
    }

    public final void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.active = this.visible = this.displayCondition.get().booleanValue();
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(graphics, this.parent.book, this.getX(), this.getY(), this.u + (this.isHoveredOrFocused() ? this.width : 0), this.v, this.width, this.height);
        if (this.isHoveredOrFocused()) {
            this.parent.setTooltip(this.getTooltipLines());
        }
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        GuiBook.playBookFlipSound(this.parent.book);
    }

    public List<Component> getTooltipLines() {
        return this.tooltip;
    }
}

