/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemTravelBelt
extends ItemBauble
implements IManaUsingItem {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/belt_travel.png");
    @OnlyIn(value=Dist.CLIENT)
    private static BipedModel<LivingEntity> model;
    private static final int COST = 1;
    private static final int COST_INTERVAL = 10;
    public static final List<String> playersWithStepup;
    public final float speed;
    public final float jump;
    public final float fallBuffer;

    public ItemTravelBelt(Item.Properties props) {
        this(props, 0.035f, 0.2f, 2.0f);
        MinecraftForge.EVENT_BUS.addListener(this::updatePlayerStepStatus);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJump);
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedOut);
    }

    public ItemTravelBelt(Item.Properties props, float speed, float jump, float fallBuffer) {
        super(props);
        this.speed = speed;
        this.jump = jump;
        this.fallBuffer = fallBuffer;
    }

    private void updatePlayerStepStatus(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack belt = EquipmentHandler.findOrEmpty(s -> s.func_77973_b() instanceof ItemTravelBelt, (LivingEntity)player);
            String s2 = ItemTravelBelt.playerStr(player);
            if (playersWithStepup.contains(s2)) {
                if (this.shouldPlayerHaveStepup(player)) {
                    ItemTravelBelt beltItem = (ItemTravelBelt)belt.func_77973_b();
                    if (player.field_70170_p.field_72995_K) {
                        if ((player.field_70122_E || player.field_71075_bZ.field_75100_b) && player.field_191988_bg > 0.0f && !player.func_203005_aq()) {
                            float speed = beltItem.getSpeed(belt);
                            player.func_213309_a(player.field_71075_bZ.field_75100_b ? speed : speed, new Vec3d(0.0, 0.0, 1.0));
                            beltItem.onMovedTick(belt, player);
                            if (player.field_70173_aa % 10 == 0) {
                                ManaItemHandler.instance().requestManaExact(belt, player, 1, true);
                            }
                        } else {
                            beltItem.onNotMovingTick(belt, player);
                        }
                    }
                    player.field_70138_W = player.func_225608_bj_() ? 0.60001f : 1.25f;
                } else {
                    player.field_70138_W = 0.6f;
                    playersWithStepup.remove(s2);
                }
            } else if (this.shouldPlayerHaveStepup(player)) {
                playersWithStepup.add(s2);
                player.field_70138_W = 1.25f;
            }
        }
    }

    public float getSpeed(ItemStack stack) {
        return this.speed;
    }

    public void onMovedTick(ItemStack stack, PlayerEntity player) {
    }

    public void onNotMovingTick(ItemStack stack, PlayerEntity player) {
    }

    private void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        ItemStack belt;
        if (event.getEntityLiving() instanceof PlayerEntity && !(belt = EquipmentHandler.findOrEmpty(s -> s.func_77973_b() instanceof ItemTravelBelt, (LivingEntity)(player = (PlayerEntity)event.getEntityLiving()))).func_190926_b() && ManaItemHandler.instance().requestManaExact(belt, player, 1, false)) {
            player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)((ItemTravelBelt)belt.func_77973_b()).jump, 0.0));
            player.field_70143_R = -((ItemTravelBelt)belt.func_77973_b()).fallBuffer;
        }
    }

    private boolean shouldPlayerHaveStepup(PlayerEntity player) {
        ItemStack result = EquipmentHandler.findOrEmpty(s -> s.func_77973_b() instanceof ItemTravelBelt, (LivingEntity)player);
        return !result.func_190926_b() && ManaItemHandler.instance().requestManaExact(result, player, 1, false);
    }

    private void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.getPlayer().func_146103_bH().getName();
        playersWithStepup.remove(username + ":false");
        playersWithStepup.remove(username + ":true");
    }

    public static String playerStr(PlayerEntity player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }

    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getRenderTexture() {
        return texture;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BaubleRenderHandler layer, ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AccessoryRenderHelper.rotateIfSneaking(ms, player);
        ms.func_227861_a_(0.0, (double)0.2f, 0.0);
        float s = 0.85f;
        ms.func_227862_a_(s, s, s);
        if (model == null) {
            model = new BipedModel(1.0f);
        }
        ResourceLocation texture = ((ItemTravelBelt)stack.func_77973_b()).getRenderTexture();
        IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(texture));
        ItemTravelBelt.model.field_78115_e.func_228309_a_(ms, buffer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    static {
        playersWithStepup = new ArrayList<String>();
    }
}

