/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.network.PacketDodge;
import vazkii.botania.common.network.PacketHandler;

public class ItemDodgeRing
extends ItemBauble {
    public static final String TAG_DODGE_COOLDOWN = "dodgeCooldown";
    public static final int MAX_CD = 20;
    private static boolean oldLeftDown;
    private static boolean oldRightDown;
    private static boolean oldForwardDown;
    private static boolean oldBackDown;
    private static int leftDown;
    private static int rightDown;
    private static int forwardDown;
    private static int backDown;

    public ItemDodgeRing(Item.Properties props) {
        super(props);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onKeyDown(InputEvent.KeyInputEvent event) {
        int oldBack;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        ItemStack ringStack = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, (LivingEntity)mc.field_71439_g);
        if (ringStack.func_190926_b() || ItemNBTHelper.getInt(ringStack, TAG_DODGE_COOLDOWN, 0) > 0) {
            return;
        }
        int threshold = 5;
        if (mc.field_71474_y.field_74370_x.func_151470_d() && !oldLeftDown) {
            leftDown = ClientTickHandler.ticksInGame;
            int oldLeft = leftDown;
            if (leftDown - oldLeft < threshold) {
                ItemDodgeRing.dodge((PlayerEntity)mc.field_71439_g, Direction.WEST);
            }
        } else if (mc.field_71474_y.field_74366_z.func_151470_d() && !oldRightDown) {
            rightDown = ClientTickHandler.ticksInGame;
            int oldRight = rightDown;
            if (rightDown - oldRight < threshold) {
                ItemDodgeRing.dodge((PlayerEntity)mc.field_71439_g, Direction.EAST);
            }
        } else if (mc.field_71474_y.field_74351_w.func_151470_d() && !oldForwardDown) {
            forwardDown = ClientTickHandler.ticksInGame;
            int oldForward = forwardDown;
            if (forwardDown - oldForward < threshold) {
                ItemDodgeRing.dodge((PlayerEntity)mc.field_71439_g, Direction.NORTH);
            }
        } else if (mc.field_71474_y.field_74368_y.func_151470_d() && !oldBackDown && (backDown = ClientTickHandler.ticksInGame) - (oldBack = backDown) < threshold) {
            ItemDodgeRing.dodge((PlayerEntity)mc.field_71439_g, Direction.SOUTH);
        }
        oldLeftDown = mc.field_71474_y.field_74370_x.func_151470_d();
        oldRightDown = mc.field_71474_y.field_74366_z.func_151470_d();
        oldForwardDown = mc.field_71474_y.field_74351_w.func_151470_d();
        oldBackDown = mc.field_71474_y.field_74368_y.func_151470_d();
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
        if (cd > 0) {
            ItemNBTHelper.setInt(stack, TAG_DODGE_COOLDOWN, cd - 1);
        }
    }

    private static void dodge(PlayerEntity player, Direction dir) {
        if (player.field_71075_bZ.field_75100_b || !player.field_70122_E || dir == Direction.UP || dir == Direction.DOWN) {
            return;
        }
        float yaw = player.field_70177_z;
        float x = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float z = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            x = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180)));
            z = MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)));
        }
        Vector3 lookVec = new Vector3(x, 0.0, z);
        Vector3 sideVec = lookVec.crossProduct(new Vector3(0.0, dir == Direction.WEST || dir == Direction.NORTH ? 1.0 : (double)(dir == Direction.EAST || dir == Direction.SOUTH ? -1 : 0), 0.0)).multiply(1.25);
        player.func_213317_d(sideVec.toVec3D());
        PacketHandler.sendToServer(new PacketDodge());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHUD(PlayerEntity player, ItemStack stack, float pticks) {
        int xo = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - 20;
        int y = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 + 20;
        if (!player.field_71075_bZ.field_75100_b) {
            int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
            int width = Math.min((int)(((float)cd - pticks) * 2.0f), 40);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (width > 0) {
                AbstractGui.fill((int)xo, (int)(y - 2), (int)(xo + 40), (int)(y - 1), (int)-2013265920);
                AbstractGui.fill((int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
            }
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

