/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.armor.ModelArmorManaweave;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemManaweaveArmor
extends ItemManasteelArmor {
    private static final LazyValue<ItemStack[]> armorSet = new LazyValue(() -> new ItemStack[]{new ItemStack((IItemProvider)ModItems.manaweaveHelm), new ItemStack((IItemProvider)ModItems.manaweaveChest), new ItemStack((IItemProvider)ModItems.manaweaveLegs), new ItemStack((IItemProvider)ModItems.manaweaveBoots)});

    public ItemManaweaveArmor(EquipmentSlotType type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getManaweaveArmorMaterial(), props);
        this.func_185043_a(new ResourceLocation("botania", "holiday"), (stack, worldIn, entityIn) -> ClientProxy.jingleTheBells ? 1.0f : 0.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> provideArmorModelForSlot(EquipmentSlotType slot) {
        return new ModelArmorManaweave(slot);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlotType slot) {
        return ((Boolean)ConfigHandler.CLIENT.enableArmorModels.get()).booleanValue() ? (ClientProxy.jingleTheBells ? "botania:textures/model/armor_manaweave_holiday.png" : "botania:textures/model/armor_manaweave.png") : (slot == EquipmentSlotType.LEGS ? "botania:textures/model/manaweave_1.png" : "botania:textures/model/manaweave_0.png");
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (ClientProxy.jingleTheBells) {
            name = name.replaceAll("manaweave", "santaweave");
        }
        return name;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return (ItemStack[])armorSet.func_179281_c();
    }

    @Override
    public boolean hasArmorSetItem(PlayerEntity player, EquipmentSlotType slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slot) {
            case HEAD: {
                return stack.func_77973_b() == ModItems.manaweaveHelm;
            }
            case CHEST: {
                return stack.func_77973_b() == ModItems.manaweaveChest;
            }
            case LEGS: {
                return stack.func_77973_b() == ModItems.manaweaveLegs;
            }
            case FEET: {
                return stack.func_77973_b() == ModItems.manaweaveBoots;
            }
        }
        return false;
    }

    @Override
    public ITextComponent getArmorSetName() {
        return new TranslationTextComponent("botania.armorset.manaweave.name", new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        if (ClientProxy.jingleTheBells) {
            list.add((ITextComponent)new TranslationTextComponent("botaniamisc.santaweaveInfo", new Object[0]));
            list.add((ITextComponent)new StringTextComponent(""));
        }
        super.addInformationAfterShift(stack, world, list, flags);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        list.add(new TranslationTextComponent("botania.armorset.manaweave.desc0", new Object[0]).func_211708_a(TextFormatting.GRAY));
        list.add(new TranslationTextComponent("botania.armorset.manaweave.desc1", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }
}

