/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IClientManaHandler;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.mana.IPingable;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.ModEntities;

public class EntityManaBurst
extends ThrowableEntity
implements IManaBurst {
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA = "mana";
    private static final String TAG_STARTING_MANA = "startingMana";
    private static final String TAG_MIN_MANA_LOSS = "minManaLoss";
    private static final String TAG_TICK_MANA_LOSS = "manaLossTick";
    private static final String TAG_SPREADER_X = "spreaderX";
    private static final String TAG_SPREADER_Y = "spreaderY";
    private static final String TAG_SPREADER_Z = "spreaderZ";
    private static final String TAG_GRAVITY = "gravity";
    private static final String TAG_LENS_STACK = "lensStack";
    private static final String TAG_LAST_MOTION_X = "lastMotionX";
    private static final String TAG_LAST_MOTION_Y = "lastMotionY";
    private static final String TAG_LAST_MOTION_Z = "lastMotionZ";
    private static final String TAG_HAS_SHOOTER = "hasShooter";
    private static final String TAG_SHOOTER_UUID_MOST = "shooterUUIDMost";
    private static final String TAG_SHOOTER_UUID_LEAST = "shooterUUIDLeast";
    private static final String TAG_LAST_COLLISION_X = "lastCollisionX";
    private static final String TAG_LAST_COLLISION_Y = "lastCollisionY";
    private static final String TAG_LAST_COLLISION_Z = "lastCollisionZ";
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MANA = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> START_MANA = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MIN_MANA_LOSS = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> MANA_LOSS_PER_TICK = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<BlockPos> SOURCE_COORDS = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<ItemStack> SOURCE_LENS = EntityDataManager.func_187226_a(EntityManaBurst.class, (IDataSerializer)DataSerializers.field_187196_f);
    private float accumulatedManaLoss = 0.0f;
    private boolean fake = false;
    private final Set<BlockPos> alreadyCollidedAt = new HashSet<BlockPos>();
    private boolean fullManaLastTick = true;
    private UUID shooterIdentity = null;
    private int _ticksExisted = 0;
    private boolean scanBeam = false;
    private BlockPos lastCollision;
    public final List<PositionProperties> propsList = new ArrayList<PositionProperties>();
    private TileEntity collidedTile = null;
    private boolean noParticles = false;

    public EntityManaBurst(EntityType<EntityManaBurst> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MANA, (Object)0);
        this.field_70180_af.func_187214_a(START_MANA, (Object)0);
        this.field_70180_af.func_187214_a(MIN_MANA_LOSS, (Object)0);
        this.field_70180_af.func_187214_a(MANA_LOSS_PER_TICK, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SOURCE_COORDS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(SOURCE_LENS, (Object)ItemStack.field_190927_a);
    }

    public EntityManaBurst(IManaSpreader spreader, boolean fake) {
        this(ModEntities.MANA_BURST, ((TileEntity)spreader).func_145831_w());
        TileEntity tile = (TileEntity)spreader;
        this.fake = fake;
        this.setBurstSourceCoords(tile.func_174877_v());
        this.func_70012_b((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_70177_z = -(spreader.getRotationX() + 90.0f);
        this.field_70125_A = spreader.getRotationY();
        float f = 0.4f;
        double mx = (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.setBurstMotion(mx, my, mz);
    }

    public EntityManaBurst(PlayerEntity player) {
        super(ModEntities.MANA_BURST, (LivingEntity)player, player.field_70170_p);
        this.setBurstSourceCoords(new BlockPos(0, -1, 0));
        this.func_70101_b(player.field_70177_z + 180.0f, -player.field_70125_A);
        float f = 0.4f;
        double mx = (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.setBurstMotion(mx, my, mz);
    }

    private void superUpdate() {
        AxisAlignedBB axisalignedbb;
        RayTraceResult raytraceresult;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (this.field_174854_a) {
            this.field_174854_a = false;
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        }
        if ((raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)(axisalignedbb = this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0)), p_213880_1_ -> !p_213880_1_.func_175149_v() && p_213880_1_.func_70067_L(), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true)).func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(((BlockRayTraceResult)raytraceresult).func_216350_a());
            } else if (!ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70184_a(raytraceresult);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)EntityManaBurst.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f2 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            float f1 = 0.8f;
        } else {
            float f1 = 0.99f;
        }
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.func_70185_h(), vec3d1.field_72449_c);
        }
        this.func_70107_b(d0, d1, d2);
    }

    public void func_70071_h_() {
        ILensEffect lens;
        this.setTicksExisted(this.getTicksExisted() + 1);
        this.superUpdate();
        if (!this.fake && this.func_70089_S() && !this.scanBeam) {
            this.ping();
        }
        if ((lens = this.getLensInstance()) != null) {
            lens.updateBurst(this, this.getSourceLens());
        }
        int mana = this.getMana();
        if (this.getTicksExisted() >= this.getMinManaLoss()) {
            this.accumulatedManaLoss += this.getManaLossPerTick();
            int loss = (int)this.accumulatedManaLoss;
            this.setMana(mana - loss);
            this.accumulatedManaLoss -= (float)loss;
            if (this.getMana() <= 0) {
                this.func_70106_y();
            }
        }
        this.particles();
        this.setBurstMotion(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
        boolean bl = this.fullManaLastTick = this.getMana() == this.getStartingMana();
        if (this.scanBeam) {
            PositionProperties props = new PositionProperties((Entity)this);
            if (this.propsList.isEmpty()) {
                this.propsList.add(props);
            } else {
                PositionProperties lastProps = this.propsList.get(this.propsList.size() - 1);
                if (!props.coordsEqual(lastProps)) {
                    this.propsList.add(props);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    public TileEntity getCollidedTile(boolean noParticles) {
        this.noParticles = noParticles;
        for (int iterations = 0; this.func_70089_S() && iterations < (Integer)ConfigHandler.COMMON.spreaderTraceTime.get(); ++iterations) {
            this.func_70071_h_();
        }
        if (this.fake) {
            this.incrementFakeParticleTick();
        }
        return this.collidedTile;
    }

    public void func_213281_b(CompoundNBT tag) {
        UUID identity;
        super.func_213281_b(tag);
        tag.func_74768_a(TAG_TICKS_EXISTED, this.getTicksExisted());
        tag.func_74768_a(TAG_COLOR, this.getColor());
        tag.func_74768_a(TAG_MANA, this.getMana());
        tag.func_74768_a(TAG_STARTING_MANA, this.getStartingMana());
        tag.func_74768_a(TAG_MIN_MANA_LOSS, this.getMinManaLoss());
        tag.func_74776_a(TAG_TICK_MANA_LOSS, this.getManaLossPerTick());
        tag.func_74776_a(TAG_GRAVITY, this.getGravity());
        ItemStack stack = this.getSourceLens();
        CompoundNBT lensCmp = new CompoundNBT();
        if (!stack.func_190926_b()) {
            lensCmp = stack.func_77955_b(lensCmp);
        }
        tag.func_218657_a(TAG_LENS_STACK, (INBT)lensCmp);
        BlockPos coords = this.getBurstSourceBlockPos();
        tag.func_74768_a(TAG_SPREADER_X, coords.func_177958_n());
        tag.func_74768_a(TAG_SPREADER_Y, coords.func_177956_o());
        tag.func_74768_a(TAG_SPREADER_Z, coords.func_177952_p());
        tag.func_74780_a(TAG_LAST_MOTION_X, this.func_213322_ci().func_82615_a());
        tag.func_74780_a(TAG_LAST_MOTION_Y, this.func_213322_ci().func_82617_b());
        tag.func_74780_a(TAG_LAST_MOTION_Z, this.func_213322_ci().func_82616_c());
        if (this.lastCollision != null) {
            tag.func_74768_a(TAG_LAST_COLLISION_X, coords.func_177958_n());
            tag.func_74768_a(TAG_LAST_COLLISION_Y, coords.func_177956_o());
            tag.func_74768_a(TAG_LAST_COLLISION_Z, coords.func_177952_p());
        }
        boolean hasShooter = (identity = this.getShooterUUID()) != null;
        tag.func_74757_a(TAG_HAS_SHOOTER, hasShooter);
        if (hasShooter) {
            tag.func_74772_a(TAG_SHOOTER_UUID_MOST, identity.getMostSignificantBits());
            tag.func_74772_a(TAG_SHOOTER_UUID_LEAST, identity.getLeastSignificantBits());
        }
    }

    public void func_70037_a(CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setTicksExisted(cmp.func_74762_e(TAG_TICKS_EXISTED));
        this.setColor(cmp.func_74762_e(TAG_COLOR));
        this.setMana(cmp.func_74762_e(TAG_MANA));
        this.setStartingMana(cmp.func_74762_e(TAG_STARTING_MANA));
        this.setMinManaLoss(cmp.func_74762_e(TAG_MIN_MANA_LOSS));
        this.setManaLossPerTick(cmp.func_74760_g(TAG_TICK_MANA_LOSS));
        this.setGravity(cmp.func_74760_g(TAG_GRAVITY));
        CompoundNBT lensCmp = cmp.func_74775_l(TAG_LENS_STACK);
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)lensCmp);
        if (!stack.func_190926_b()) {
            this.setSourceLens(stack);
        } else {
            this.setSourceLens(ItemStack.field_190927_a);
        }
        int x = cmp.func_74762_e(TAG_SPREADER_X);
        int y = cmp.func_74762_e(TAG_SPREADER_Y);
        int z = cmp.func_74762_e(TAG_SPREADER_Z);
        this.setBurstSourceCoords(new BlockPos(x, y, z));
        if (cmp.func_74764_b(TAG_LAST_COLLISION_X)) {
            x = cmp.func_74762_e(TAG_SPREADER_X);
            y = cmp.func_74762_e(TAG_SPREADER_Y);
            z = cmp.func_74762_e(TAG_SPREADER_Z);
            this.lastCollision = new BlockPos(x, y, z);
        }
        double lastMotionX = cmp.func_74769_h(TAG_LAST_MOTION_X);
        double lastMotionY = cmp.func_74769_h(TAG_LAST_MOTION_Y);
        double lastMotionZ = cmp.func_74769_h(TAG_LAST_MOTION_Z);
        this.setBurstMotion(lastMotionX, lastMotionY, lastMotionZ);
        boolean hasShooter = cmp.func_74767_n(TAG_HAS_SHOOTER);
        if (hasShooter) {
            long most = cmp.func_74763_f(TAG_SHOOTER_UUID_MOST);
            long least = cmp.func_74763_f(TAG_SHOOTER_UUID_LEAST);
            UUID identity = this.getShooterUUID();
            if (identity == null || most != identity.getMostSignificantBits() || least != identity.getLeastSignificantBits()) {
                this.shooterIdentity = new UUID(most, least);
            }
        }
    }

    public void particles() {
        float osize;
        if (!this.func_70089_S() || !this.field_70170_p.field_72995_K) {
            return;
        }
        ILensEffect lens = this.getLensInstance();
        if (lens != null && !lens.doParticles(this, this.getSourceLens())) {
            return;
        }
        int color = this.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float size = osize = this.getParticleSize();
        if (this.fake) {
            if (this.getMana() == this.getStartingMana()) {
                size = 2.0f;
            } else if (this.fullManaLastTick) {
                size = 4.0f;
            }
            if (!this.noParticles && this.shouldDoFakeParticles()) {
                SparkleParticleData data = SparkleParticleData.fake(0.4f * size, r, g, b, 1);
                Botania.proxy.addParticleForce(this.field_70170_p, data, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        } else {
            boolean depth;
            boolean bl = depth = !Botania.proxy.isClientPlayerWearingMonocle();
            if (((Boolean)ConfigHandler.CLIENT.subtlePowerSystem.get()).booleanValue()) {
                WispParticleData data = WispParticleData.wisp(0.1f * size, r, g, b, depth);
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)((float)(Math.random() - 0.5) * 0.02f), (double)((float)(Math.random() - 0.5) * 0.02f), (double)((float)(Math.random() - 0.5) * 0.01f));
            } else {
                WispParticleData data;
                float or = r;
                float og = g;
                float ob = b;
                double luminance = 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
                double iterX = this.func_226277_ct_();
                double iterY = this.func_226278_cu_();
                double iterZ = this.func_226281_cx_();
                Vector3 currentPos = Vector3.fromEntity((Entity)this);
                Vector3 oldPos = new Vector3(this.field_70169_q, this.field_70167_r, this.field_70166_s);
                Vector3 diffVec = oldPos.subtract(currentPos);
                Vector3 diffVecNorm = diffVec.normalize();
                double distance = 0.095;
                do {
                    if (luminance < 0.1) {
                        r = or + (float)Math.random() * 0.125f;
                        g = og + (float)Math.random() * 0.125f;
                        b = ob + (float)Math.random() * 0.125f;
                    }
                    size = osize + ((float)Math.random() - 0.5f) * 0.065f + (float)Math.sin(new Random(this.field_96093_i.getMostSignificantBits()).nextInt(9001)) * 0.4f;
                    data = WispParticleData.wisp(0.2f * size, r, g, b, depth);
                    this.field_70170_p.func_195594_a((IParticleData)data, iterX, iterY, iterZ, (double)((float)(-this.func_213322_ci().func_82615_a()) * 0.01f), (double)((float)(-this.func_213322_ci().func_82617_b()) * 0.01f), (double)((float)(-this.func_213322_ci().func_82616_c()) * 0.01f));
                    currentPos = new Vector3(iterX += diffVecNorm.x * distance, iterY += diffVecNorm.y * distance, iterZ += diffVecNorm.z * distance);
                    diffVec = oldPos.subtract(currentPos);
                } while (!this.getPersistentData().func_74764_b("orbit") && Math.abs(diffVec.mag()) > distance);
                data = WispParticleData.wisp(0.1f * size, or, og, ob, depth);
                this.field_70170_p.func_195594_a((IParticleData)data, iterX, iterY, iterZ, (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f));
            }
        }
    }

    public float getParticleSize() {
        return (float)this.getMana() / (float)this.getStartingMana();
    }

    protected void func_70184_a(@Nonnull RayTraceResult rtr) {
        ILensEffect lens;
        BlockPos pos = null;
        boolean dead = false;
        if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
            pos = ((BlockRayTraceResult)rtr).func_216350_a();
            if (pos.equals((Object)this.lastCollision)) {
                return;
            }
            this.lastCollision = pos.func_185334_h();
            TileEntity tile = this.field_70170_p.func_175625_s(pos);
            BlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IManaCollisionGhost && ((IManaCollisionGhost)block).isGhost(state, this.field_70170_p, pos) && !(block instanceof IManaTrigger) || block instanceof BushBlock || block instanceof LeavesBlock) {
                return;
            }
            BlockPos coords = this.getBurstSourceBlockPos();
            if (tile != null && !tile.func_174877_v().equals((Object)coords)) {
                this.collidedTile = tile;
            }
            if (tile == null || !tile.func_174877_v().equals((Object)coords)) {
                boolean ghost;
                if (!this.fake && !this.noParticles && (!this.field_70170_p.field_72995_K || tile instanceof IClientManaHandler) && tile != null && tile instanceof IManaReceiver && ((IManaReceiver)tile).canReceiveManaFromBursts()) {
                    this.onReceiverImpact((IManaReceiver)tile, tile.func_174877_v());
                }
                if (block instanceof IManaTrigger) {
                    ((IManaTrigger)block).onBurstCollision(this, this.field_70170_p, pos);
                }
                boolean bl = dead = !(ghost = block instanceof IManaCollisionGhost);
                if (ghost) {
                    return;
                }
            }
        }
        if ((lens = this.getLensInstance()) != null) {
            dead = lens.collideBurst(this, rtr, this.collidedTile instanceof IManaReceiver && ((IManaReceiver)this.collidedTile).canReceiveManaFromBursts(), dead, this.getSourceLens());
        }
        if (pos != null && !this.hasAlreadyCollidedAt(pos)) {
            this.alreadyCollidedAt.add(pos);
        }
        if (dead && this.func_70089_S()) {
            if (!this.fake && this.field_70170_p.field_72995_K) {
                int color = this.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                int mana = this.getMana();
                int maxMana = this.getStartingMana();
                float size = (float)mana / (float)maxMana;
                if (!((Boolean)ConfigHandler.CLIENT.subtlePowerSystem.get()).booleanValue()) {
                    for (int i = 0; i < 4; ++i) {
                        WispParticleData data = WispParticleData.wisp(0.15f * size, r, g, b);
                        this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f));
                    }
                }
                SparkleParticleData data = SparkleParticleData.sparkle(4.0f, r, g, b, 2);
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            this.func_70106_y();
        }
    }

    private void onReceiverImpact(IManaReceiver tile, BlockPos pos) {
        if (this.getPersistentData().func_74767_n("botania:warped")) {
            return;
        }
        ILensEffect lens = this.getLensInstance();
        int mana = this.getMana();
        if (lens != null) {
            ItemStack stack = this.getSourceLens();
            mana = lens.getManaToTransfer(this, this, stack, tile);
        }
        if (tile instanceof IManaCollector) {
            mana = (int)((float)mana * ((IManaCollector)tile).getManaYieldMultiplier(this));
        }
        tile.receiveMana(mana);
        if (tile instanceof IThrottledPacket) {
            ((IThrottledPacket)((Object)tile)).markDispatchable();
        } else {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)tile);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.fake) {
            TileEntity tile = this.getShooter();
            if (tile instanceof IManaSpreader) {
                ((IManaSpreader)tile).setCanShoot(true);
            }
        } else {
            this.setDeathTicksForFakeParticle();
        }
    }

    private TileEntity getShooter() {
        return this.field_70170_p.func_175625_s(this.getBurstSourceBlockPos());
    }

    protected float func_70185_h() {
        return this.getGravity();
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public void setScanBeam() {
        this.scanBeam = true;
    }

    @Override
    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    @Override
    public int getMana() {
        return (Integer)this.field_70180_af.func_187225_a(MANA);
    }

    @Override
    public void setMana(int mana) {
        this.field_70180_af.func_187227_b(MANA, (Object)mana);
    }

    @Override
    public int getStartingMana() {
        return (Integer)this.field_70180_af.func_187225_a(START_MANA);
    }

    @Override
    public void setStartingMana(int mana) {
        this.field_70180_af.func_187227_b(START_MANA, (Object)mana);
    }

    @Override
    public int getMinManaLoss() {
        return (Integer)this.field_70180_af.func_187225_a(MIN_MANA_LOSS);
    }

    @Override
    public void setMinManaLoss(int minManaLoss) {
        this.field_70180_af.func_187227_b(MIN_MANA_LOSS, (Object)minManaLoss);
    }

    @Override
    public float getManaLossPerTick() {
        return ((Float)this.field_70180_af.func_187225_a(MANA_LOSS_PER_TICK)).floatValue();
    }

    @Override
    public void setManaLossPerTick(float mana) {
        this.field_70180_af.func_187227_b(MANA_LOSS_PER_TICK, (Object)Float.valueOf(mana));
    }

    @Override
    public float getGravity() {
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    @Override
    public void setGravity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
    }

    @Override
    public BlockPos getBurstSourceBlockPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(SOURCE_COORDS);
    }

    @Override
    public void setBurstSourceCoords(BlockPos pos) {
        this.field_70180_af.func_187227_b(SOURCE_COORDS, (Object)pos);
    }

    @Override
    public ItemStack getSourceLens() {
        return (ItemStack)this.field_70180_af.func_187225_a(SOURCE_LENS);
    }

    @Override
    public void setSourceLens(ItemStack lens) {
        this.field_70180_af.func_187227_b(SOURCE_LENS, (Object)lens);
    }

    @Override
    public int getTicksExisted() {
        return this._ticksExisted;
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    private ILensEffect getLensInstance() {
        ItemStack lens = this.getSourceLens();
        if (!lens.func_190926_b() && lens.func_77973_b() instanceof ILensEffect) {
            return (ILensEffect)lens.func_77973_b();
        }
        return null;
    }

    @Override
    public void setBurstMotion(double x, double y, double z) {
        this.func_213293_j(x, y, z);
    }

    @Override
    public boolean hasAlreadyCollidedAt(BlockPos pos) {
        return this.alreadyCollidedAt.contains(pos);
    }

    @Override
    public void setCollidedAt(BlockPos pos) {
        if (!this.hasAlreadyCollidedAt(pos)) {
            this.alreadyCollidedAt.add(pos.func_185334_h());
        }
    }

    @Override
    public void setShooterUUID(UUID uuid) {
        this.shooterIdentity = uuid;
    }

    @Override
    public UUID getShooterUUID() {
        return this.shooterIdentity;
    }

    @Override
    public void ping() {
        TileEntity tile = this.getShooter();
        if (tile != null && tile instanceof IPingable) {
            ((IPingable)tile).pingback(this, this.getShooterUUID());
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected boolean shouldDoFakeParticles() {
        if (((Boolean)ConfigHandler.CLIENT.staticWandBeam.get()).booleanValue()) {
            return true;
        }
        TileEntity tile = this.getShooter();
        return tile instanceof IManaSpreader && (this.getMana() != this.getStartingMana() && this.fullManaLastTick || Math.abs(((IManaSpreader)tile).getBurstParticleTick() - this.getTicksExisted()) < 4);
    }

    private void incrementFakeParticleTick() {
        TileEntity tile = this.getShooter();
        if (tile instanceof IManaSpreader) {
            IManaSpreader spreader = (IManaSpreader)tile;
            spreader.setBurstParticleTick(spreader.getBurstParticleTick() + 2);
            if (spreader.getLastBurstDeathTick() != -1 && spreader.getBurstParticleTick() > spreader.getLastBurstDeathTick()) {
                spreader.setBurstParticleTick(0);
            }
        }
    }

    private void setDeathTicksForFakeParticle() {
        BlockPos coords = this.getBurstSourceBlockPos();
        TileEntity tile = this.field_70170_p.func_175625_s(coords);
        if (tile != null && tile instanceof IManaSpreader) {
            ((IManaSpreader)tile).setLastBurstDeathTick(this.getTicksExisted());
        }
    }

    public static class PositionProperties {
        public final BlockPos coords;
        public final BlockState state;
        public boolean invalid = false;

        public PositionProperties(Entity entity) {
            int x = MathHelper.func_76128_c((double)entity.func_226277_ct_());
            int y = MathHelper.func_76128_c((double)entity.func_226278_cu_());
            int z = MathHelper.func_76128_c((double)entity.func_226281_cx_());
            this.coords = new BlockPos(x, y, z);
            this.state = entity.field_70170_p.func_180495_p(this.coords);
        }

        public boolean coordsEqual(PositionProperties props) {
            return this.coords.equals((Object)props.coords);
        }

        public boolean contentsEqual(World world) {
            if (!world.func_175667_e(this.coords)) {
                this.invalid = true;
                return false;
            }
            return world.func_180495_p(this.coords) == this.state;
        }

        public int hashCode() {
            return Objects.hash(this.coords, this.state);
        }

        public boolean equals(Object o) {
            return o instanceof PositionProperties && ((PositionProperties)o).state == this.state && ((PositionProperties)o).coords.equals((Object)this.coords);
        }
    }
}

