/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class HelmRevealingRecipe
implements ICraftingRecipe {
    private final ShapelessRecipe compose;
    private static final String TAG_RUNIC = "TC.RUNIC";
    private static final String TAG_WARP = "TC.WARP";
    private static final String TAG_INFUSION_ENCH = "infench";
    public static final IRecipeSerializer<HelmRevealingRecipe> SERIALIZER = new Serializer();

    public HelmRevealingRecipe(ShapelessRecipe compose) {
        this.compose = compose;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        return this.compose.func_77569_a(inv, world);
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack helm = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !Registry.field_212630_s.func_177774_c((Object)stack.func_77973_b()).func_110624_b().equals("botania")) continue;
            helm = stack;
        }
        if (helm.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newHelm = this.compose.func_77572_b(inv);
        for (int i = 0; i < 6; ++i) {
            if (!ItemNBTHelper.getBoolean(helm, "AncientWill" + i, false)) continue;
            ItemNBTHelper.setBoolean(newHelm, "AncientWill" + i, true);
        }
        ListNBT enchList = ItemNBTHelper.getList(helm, "ench", 10, true);
        if (enchList != null) {
            ItemNBTHelper.setList(newHelm, "ench", enchList);
        }
        HelmRevealingRecipe.copyTCData(helm, newHelm);
        return newHelm;
    }

    public boolean func_194133_a(int width, int height) {
        return this.compose.func_194133_a(width, height);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.compose.func_77571_b();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.compose.func_192400_c();
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.compose.func_199560_c();
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static void copyTCData(ItemStack source, ItemStack destination) {
        ListNBT infEnchList;
        byte warp;
        byte runicShielding = ItemNBTHelper.getByte(source, TAG_RUNIC, (byte)0);
        if (runicShielding != 0) {
            ItemNBTHelper.setByte(destination, TAG_RUNIC, runicShielding);
        }
        if ((warp = ItemNBTHelper.getByte(source, TAG_WARP, (byte)0)) != 0) {
            ItemNBTHelper.setByte(destination, TAG_WARP, warp);
        }
        if ((infEnchList = ItemNBTHelper.getList(source, TAG_INFUSION_ENCH, 10, true)) != null) {
            ItemNBTHelper.setList(destination, TAG_INFUSION_ENCH, infEnchList);
        }
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<HelmRevealingRecipe> {
        private Serializer() {
        }

        @Nonnull
        public HelmRevealingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return new HelmRevealingRecipe((ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199425_a_(recipeId, json));
        }

        public HelmRevealingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            return new HelmRevealingRecipe((ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199426_a_(recipeId, buffer));
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull HelmRevealingRecipe recipe) {
            IRecipeSerializer.field_222158_b.func_199427_a_(buffer, (IRecipe)recipe.compose);
        }
    }
}

