/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.recipe.StateIngredient;

public class StateIngredientBlocks
implements StateIngredient {
    private final Set<Block> blocks;

    public StateIngredientBlocks(Set<Block> blocks) {
        this.blocks = blocks;
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains(state.func_177230_c());
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "blocks");
        JsonArray array = new JsonArray();
        for (Block block : this.blocks) {
            array.add(Registry.field_212618_g.func_177774_c((Object)block).toString());
        }
        object.add("blocks", (JsonElement)array);
        return object;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(0);
        buffer.func_150787_b(this.blocks.size());
        for (Block block : this.blocks) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block);
        }
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.blocks.stream().map(Block::func_176223_P).collect(Collectors.toList());
    }
}

