/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class RecipeBrew
implements IBrewRecipe {
    private final ResourceLocation id;
    private final Brew brew;
    private final NonNullList<Ingredient> inputs;

    public RecipeBrew(ResourceLocation id, Brew brew, Ingredient ... inputs) {
        this.id = id;
        this.brew = brew;
        this.inputs = NonNullList.func_193580_a(null, (Object[])inputs);
    }

    public boolean matches(RecipeWrapper inv, @Nonnull World world) {
        ItemStack stack;
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.func_70302_i_() && !(stack = inv.func_70301_a(i)).func_190926_b(); ++i) {
            if (stack.func_77973_b() instanceof IBrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                Ingredient input = (Ingredient)iter.next();
                if (!input.test(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.brewery);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.BREW_SERIALIZER;
    }

    @Override
    public Brew getBrew() {
        return this.brew;
    }

    @Override
    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    @Override
    public ItemStack getOutput(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBrewContainer)) {
            return new ItemStack((IItemProvider)Items.field_151069_bo);
        }
        IBrewContainer container = (IBrewContainer)stack.func_77973_b();
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this.brew)).hashCode() ^ this.inputs.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RecipeBrew && this.brew == ((RecipeBrew)o).brew && this.inputs.equals(((RecipeBrew)o).inputs);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeBrew> {
        @Nonnull
        public RecipeBrew read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            String brewStr = JSONUtils.func_151200_h((JsonObject)json, (String)"brew");
            ResourceLocation brewId = ResourceLocation.func_208304_a((String)brewStr);
            if (brewId == null || !BotaniaAPI.instance().getBrewRegistry().containsKey(brewId)) {
                throw new JsonParseException("Unknown brew " + brewStr);
            }
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().getValue(brewId);
            JsonArray ingrs = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new RecipeBrew(id, brew, inputs.toArray(new Ingredient[0]));
        }

        public RecipeBrew read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buf) {
            Brew brew = (Brew)buf.readRegistryIdUnsafe(BotaniaAPI.instance().getBrewRegistry());
            Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
            }
            return new RecipeBrew(id, brew, inputs);
        }

        public void write(@Nonnull PacketBuffer buf, @Nonnull RecipeBrew recipe) {
            buf.writeRegistryIdUnsafe(BotaniaAPI.instance().getBrewRegistry(), (IForgeRegistryEntry)recipe.getBrew());
            buf.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient input : recipe.func_192400_c()) {
                input.func_199564_a(buf);
            }
        }
    }
}

