/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import net.minecraft.entity.Entity;
import vazkii.botania.common.core.helper.Vector3;

public final class MathHelper {
    public static float pointDistanceSpace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static void setEntityMotionFromVector(Entity entity, Vector3 originalPosVector, float modifier) {
        Vector3 entityVector = Vector3.fromEntityCenter(entity);
        Vector3 finalVector = originalPosVector.subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector = finalVector.normalize();
        }
        entity.func_213317_d(finalVector.multiply(modifier).toVec3D());
    }

    public static int multiplyColor(int c1, int c2) {
        int r1 = (c1 & 0xFF0000) >> 16;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int g2 = (c2 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * ((float)r2 / 255.0f));
        int g = (int)((float)g1 * ((float)g2 / 255.0f));
        int b = (int)((float)b1 * ((float)b2 / 255.0f));
        return c1 & 0xFF000000 | r << 16 | g << 8 | b;
    }
}

