/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LazyValue;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.recipe.ElvenPortalUpdateEvent;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfPortalBreadTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileAlfPortal
extends TileMod
implements ITickableTileEntity {
    public static final LazyValue<IMultiblock> MULTIBLOCK = new LazyValue(() -> PatchouliAPI.instance.makeMultiblock((String[][])new String[][]{{"_", "W", "G", "W", "_"}, {"W", " ", " ", " ", "W"}, {"G", " ", " ", " ", "G"}, {"W", " ", " ", " ", "W"}, {"_", "W", "0", "W", "_"}}, new Object[]{Character.valueOf('W'), ModBlocks.livingwood, Character.valueOf('G'), ModBlocks.livingwoodGlimmering, Character.valueOf('0'), ModBlocks.alfPortal}));
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    private static final String TAG_PORTAL_FLAG = "_elvenPortal";
    private final List<ItemStack> stacksIn = new ArrayList<ItemStack>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean explode = false;
    @Nullable
    private UUID breadPlayer = null;

    public TileAlfPortal() {
        super(ModTiles.ALF_PORTAL);
    }

    public void func_73660_a() {
        if (this.func_195044_w().func_177229_b(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF) {
            this.ticksOpen = 0;
            return;
        }
        AlfPortalState state = (AlfPortalState)((Object)this.func_195044_w().func_177229_b(BotaniaStateProps.ALFPORTAL_STATE));
        AlfPortalState newState = this.getValidState();
        ++this.ticksOpen;
        AxisAlignedBB aabb = this.getPortalAABB();
        boolean open = this.ticksOpen > 60;
        ElvenPortalUpdateEvent event = new ElvenPortalUpdateEvent(this, aabb, open, this.stacksIn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (this.ticksOpen > 60) {
            ++this.ticksSinceLastItem;
            if (this.field_145850_b.field_72995_K && ((Boolean)ConfigHandler.CLIENT.elfPortalParticlesEnabled.get()).booleanValue()) {
                this.blockParticle(state);
            }
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, aabb);
            if (!this.field_145850_b.field_72995_K) {
                for (ItemEntity item : items) {
                    if (!item.func_70089_S()) continue;
                    ItemStack stack = item.func_92059_d();
                    boolean consume = item.getPersistentData().func_74764_b(TAG_PORTAL_FLAG) ? false : (stack.func_77973_b() instanceof ItemLexicon ? true : !(stack.func_77973_b() instanceof IElvenItem) || !((IElvenItem)stack.func_77973_b()).isElvenItem(stack));
                    if (!consume) continue;
                    item.func_70106_y();
                    if (this.validateItemUsage(item)) {
                        this.addItem(stack);
                    }
                    this.ticksSinceLastItem = 0;
                }
            }
            if (!this.field_145850_b.field_72995_K && !this.stacksIn.isEmpty() && this.ticksSinceLastItem >= 4) {
                this.resolveRecipes();
            }
        }
        if (this.closeNow) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), ModBlocks.alfPortal.func_176223_P());
            for (int i = 0; i < 36; ++i) {
                this.blockParticle(state);
            }
            this.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    this.blockParticle(state);
                }
            }
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)));
        } else if (this.explode) {
            PlayerEntity entity;
            this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 0.5, 3.0f, Explosion.Mode.DESTROY);
            this.explode = false;
            if (!this.field_145850_b.field_72995_K && this.breadPlayer != null && (entity = this.field_145850_b.func_217371_b(this.breadPlayer)) instanceof ServerPlayerEntity) {
                AlfPortalBreadTrigger.INSTANCE.trigger((ServerPlayerEntity)entity, this.func_174877_v());
            }
            this.breadPlayer = null;
        }
    }

    private boolean validateItemUsage(ItemEntity entity) {
        ItemStack inputStack = entity.func_92059_d();
        for (IRecipe recipe : this.field_145850_b.func_199532_z().func_215366_a(ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            if (!(recipe instanceof IElvenTradeRecipe) || !((IElvenTradeRecipe)recipe).containsItem(inputStack)) continue;
            return true;
        }
        if (inputStack.func_77973_b() == Items.field_151025_P) {
            this.explode = true;
            this.breadPlayer = entity.func_200214_m();
        }
        return false;
    }

    private void blockParticle(AlfPortalState state) {
        double dy;
        double dh;
        switch (this.field_145850_b.field_73012_v.nextInt(9)) {
            default: {
                dh = 0.0;
                dy = 1.0;
                break;
            }
            case 1: {
                dh = 0.0;
                dy = 2.0;
                break;
            }
            case 2: {
                dh = 0.0;
                dy = 3.0;
                break;
            }
            case 3: {
                dh = -1.0;
                dy = 1.0;
                break;
            }
            case 4: {
                dh = -1.0;
                dy = 2.0;
                break;
            }
            case 5: {
                dh = -1.0;
                dy = 3.0;
                break;
            }
            case 6: {
                dh = 1.0;
                dy = 1.0;
                break;
            }
            case 7: {
                dh = 1.0;
                dy = 2.0;
                break;
            }
            case 8: {
                dh = 1.0;
                dy = 3.0;
            }
        }
        double dx = state == AlfPortalState.ON_X ? 0.0 : dh;
        double dz = state == AlfPortalState.ON_Z ? 0.0 : dh;
        float motionMul = 0.2f;
        WispParticleData data = WispParticleData.wisp((float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25));
        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.func_174877_v().func_177958_n() + dx, (double)this.func_174877_v().func_177956_o() + dy, (double)this.func_174877_v().func_177952_p() + dz, (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul));
    }

    public boolean onWanded() {
        AlfPortalState newState;
        AlfPortalState state = (AlfPortalState)((Object)this.func_195044_w().func_177229_b(BotaniaStateProps.ALFPORTAL_STATE));
        if (state == AlfPortalState.OFF && (newState = this.getValidState()) != AlfPortalState.OFF) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            return true;
        }
        return false;
    }

    private AxisAlignedBB getPortalAABB() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 1, 0), this.field_174879_c.func_177982_a(2, 4, 1));
        if (this.func_195044_w().func_177229_b(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.ON_X) {
            aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, -1), this.field_174879_c.func_177982_a(1, 4, 2));
        }
        return aabb;
    }

    private void addItem(ItemStack stack) {
        int size = stack.func_190916_E();
        stack.func_190920_e(1);
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.func_77946_l());
        }
    }

    public static Collection<IElvenTradeRecipe> elvenTradeRecipes(RecipeManager rm) {
        return rm.func_215366_a(ModRecipeTypes.ELVEN_TRADE_TYPE).values();
    }

    private void resolveRecipes() {
        List<BlockPos> pylons = this.locatePylons();
        for (IRecipe r : this.field_145850_b.func_199532_z().func_215366_a(ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            IElvenTradeRecipe recipe;
            Optional<List<ItemStack>> match;
            if (!(r instanceof IElvenTradeRecipe) || !(match = (recipe = (IElvenTradeRecipe)r).match(this.stacksIn)).isPresent()) continue;
            if (!this.consumeMana(pylons, 500, false)) break;
            List<ItemStack> inputs = match.get();
            for (ItemStack stack : inputs) {
                this.stacksIn.remove(stack);
            }
            for (ItemStack output : recipe.getOutputs(inputs)) {
                this.spawnItem(output.func_77946_l());
            }
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
        item.getPersistentData().func_74757_a(TAG_PORTAL_FLAG, true);
        this.field_145850_b.func_217376_c((Entity)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT cmp) {
        CompoundNBT ret = super.func_189515_b(cmp);
        cmp.func_74768_a(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            CompoundNBT stackcmp = stack.func_77955_b(new CompoundNBT());
            cmp.func_218657_a(TAG_STACK + i, (INBT)stackcmp);
            ++i;
        }
        return ret;
    }

    @Override
    public void func_145839_a(CompoundNBT cmp) {
        super.func_145839_a(cmp);
        int count = cmp.func_74762_e(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            CompoundNBT stackcmp = cmp.func_74775_l(TAG_STACK + i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.func_74768_a(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.ticksOpen = cmp.func_74762_e(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.func_74762_e(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private AlfPortalState getValidState() {
        Rotation rot = ((IMultiblock)MULTIBLOCK.func_179281_c()).validate(this.field_145850_b, this.func_174877_v());
        if (rot == null) {
            return AlfPortalState.OFF;
        }
        this.lightPylons();
        switch (rot) {
            default: {
                return AlfPortalState.ON_Z;
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: 
        }
        return AlfPortalState.ON_X;
    }

    public List<BlockPos> locatePylons() {
        int range = 5;
        BlockState pylonState = ModBlocks.naturaPylon.func_176223_P();
        return BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(-range, -range, -range), (BlockPos)this.func_174877_v().func_177982_a(range, range, range)).filter(arg_0 -> ((World)this.field_145850_b).func_175667_e(arg_0)).filter(p -> this.field_145850_b.func_180495_p(p) == pylonState && this.field_145850_b.func_180495_p(p.func_177977_b()).func_177230_c() instanceof BlockPool).map(BlockPos::func_185334_h).collect(Collectors.toList());
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        List<BlockPos> pylons = this.locatePylons();
        for (BlockPos pos : pylons) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (!(tile instanceof TilePylon)) continue;
            TilePylon pylon = (TilePylon)tile;
            pylon.activated = true;
            pylon.centerPos = this.func_174877_v();
        }
        if (this.ticksOpen == 50) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(List<BlockPos> pylons, int totalCost, boolean close) {
        ArrayList<TilePool> consumePools = new ArrayList<TilePool>();
        int consumed = 0;
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (BlockPos pos : pylons) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile instanceof TilePylon) {
                TilePylon pylon = (TilePylon)tile;
                pylon.activated = true;
                pylon.centerPos = this.func_174877_v();
            }
            if (!((tile = this.field_145850_b.func_175625_s(pos.func_177977_b())) instanceof TilePool)) continue;
            TilePool pool = (TilePool)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.field_145850_b.field_72995_K) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (TilePool pool : consumePools) {
                pool.receiveMana(-costPer);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

