/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketItemAge;

public class SubTileDaffomill
extends TileEntityFunctionalFlower {
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_WIND_TICKS = "windTicks";
    private int windTicks = 0;
    private Direction orientation = Direction.NORTH;

    public SubTileDaffomill() {
        super(ModSubtiles.DAFFOMILL);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_73012_v.nextInt(4) == 0) {
            WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.15f, 0.05f, 0.05f, 0.05f);
            this.field_145850_b.func_195594_a((IParticleData)data, (double)this.getEffectivePos().func_177958_n() + Math.random(), (double)this.getEffectivePos().func_177956_o() + Math.random(), (double)this.getEffectivePos().func_177952_p() + Math.random(), (double)((float)this.orientation.func_82601_c() * 0.1f), (double)((float)this.orientation.func_96559_d() * 0.1f), (double)((float)this.orientation.func_82599_e() * 0.1f));
        }
        if (this.windTicks == 0 && this.getMana() > 0) {
            this.windTicks = 20;
            this.addMana(-1);
        }
        if (this.windTicks > 0 && this.redstoneSignal == 0) {
            AxisAlignedBB axis = this.aabbForOrientation();
            if (axis != null) {
                List items = this.func_145831_w().func_217357_a(ItemEntity.class, axis);
                int slowdown = this.getSlowdownFactor();
                for (ItemEntity item : items) {
                    if (!item.func_70089_S() || item.field_70292_b < slowdown) continue;
                    item.func_213293_j(item.func_213322_ci().func_82615_a() + (double)this.orientation.func_82601_c() * 0.05, item.func_213322_ci().func_82617_b() + (double)this.orientation.func_96559_d() * 0.05, item.func_213322_ci().func_82616_c() + (double)this.orientation.func_82599_e() * 0.05);
                }
            }
            --this.windTicks;
        }
    }

    private AxisAlignedBB aabbForOrientation() {
        int x = this.getEffectivePos().func_177958_n();
        int y = this.getEffectivePos().func_177956_o();
        int z = this.getEffectivePos().func_177952_p();
        int w = 2;
        int h = 3;
        int l = 16;
        AxisAlignedBB axis = null;
        switch (this.orientation) {
            case NORTH: {
                axis = new AxisAlignedBB((double)(x - w), (double)(y - h), (double)(z - l), (double)(x + w + 1), (double)(y + h), (double)z);
                break;
            }
            case SOUTH: {
                axis = new AxisAlignedBB((double)(x - w), (double)(y - h), (double)(z + 1), (double)(x + w + 1), (double)(y + h), (double)(z + l + 1));
                break;
            }
            case WEST: {
                axis = new AxisAlignedBB((double)(x - l), (double)(y - h), (double)(z - w), (double)x, (double)(y + h), (double)(z + w + 1));
                break;
            }
            case EAST: {
                axis = new AxisAlignedBB((double)(x + 1), (double)(y - h), (double)(z - w), (double)(x + l + 1), (double)(y + h), (double)(z + w + 1));
                break;
            }
        }
        return axis;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onWanded(PlayerEntity player, ItemStack wand) {
        if (player == null) {
            return false;
        }
        if (player.func_225608_bj_()) {
            if (!player.field_70170_p.field_72995_K) {
                this.orientation = this.orientation.func_176746_e();
                this.sync();
            }
            return true;
        }
        return super.onWanded(player, wand);
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            this.orientation = entity.func_174811_aO();
        }
        super.onBlockPlacedBy(world, pos, state, entity, stack);
    }

    @Override
    public RadiusDescriptor getRadius() {
        AxisAlignedBB aabb = this.aabbForOrientation();
        aabb = new AxisAlignedBB(aabb.field_72340_a, (double)this.getEffectivePos().func_177956_o(), aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        return new RadiusDescriptor.Rectangle(this.getEffectivePos(), aabb);
    }

    @Override
    public int getColor() {
        return 14203392;
    }

    @Override
    public int getMaxMana() {
        return 100;
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_ORIENTATION, this.orientation.func_176745_a());
        cmp.func_74768_a(TAG_WIND_TICKS, this.windTicks);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.orientation = Direction.func_82600_a((int)cmp.func_74762_e(TAG_ORIENTATION));
        this.windTicks = cmp.func_74762_e(TAG_WIND_TICKS);
    }

    public static void onItemTrack(PlayerEvent.StartTracking evt) {
        if (evt.getTarget() instanceof ItemEntity) {
            int entityId = evt.getTarget().func_145782_y();
            int age = ((ItemEntity)evt.getTarget()).field_70292_b;
            PacketHandler.sendTo((ServerPlayerEntity)evt.getPlayer(), new PacketItemAge(entityId, age));
        }
    }
}

