/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileBellethorn
extends TileEntityFunctionalFlower {
    public static final int RANGE = 6;
    public static final int RANGE_MINI = 1;

    public SubTileBellethorn(TileEntityType<?> type) {
        super(type);
    }

    public SubTileBellethorn() {
        this(ModSubtiles.BELLETHORNE);
    }

    @Override
    public int getColor() {
        return 12203041;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        int manaToUse = this.getManaCost();
        if (this.ticksExisted % 5 == 0) {
            int range = this.getRange();
            List entities = this.func_145831_w().func_175647_a(LivingEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-range, -range, -range), this.getEffectivePos().func_177982_a(range + 1, range + 1, range + 1)), this.getSelector());
            for (LivingEntity entity : entities) {
                if (entity.field_70737_aN != 0 || this.getMana() < manaToUse) continue;
                int dmg = 4;
                if (entity instanceof WitchEntity) {
                    dmg = 20;
                }
                entity.func_70097_a(DamageSource.field_76376_m, (float)dmg);
                this.addMana(-manaToUse);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getManaCost() {
        return 24;
    }

    public int getRange() {
        return 6;
    }

    public Predicate<Entity> getSelector() {
        return entity -> !(entity instanceof PlayerEntity);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SubTileBellethorn {
        public Mini() {
            super(ModSubtiles.BELLETHORNE_CHIBI);
        }

        @Override
        public int getRange() {
            return 1;
        }
    }
}

