/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.SkyRenderHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class SkyblockSkyRenderer
implements SkyRenderHandler {
    private static final ResourceLocation textureSkybox = new ResourceLocation("botania:textures/misc/skybox.png");
    private static final ResourceLocation textureRainbow = new ResourceLocation("botania:textures/misc/rainbow.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation[] planetTextures = new ResourceLocation[]{new ResourceLocation("botania:textures/misc/planet0.png"), new ResourceLocation("botania:textures/misc/planet1.png"), new ResourceLocation("botania:textures/misc/planet2.png"), new ResourceLocation("botania:textures/misc/planet3.png"), new ResourceLocation("botania:textures/misc/planet4.png"), new ResourceLocation("botania:textures/misc/planet5.png")};

    public void render(int ticks, float partialTicks, MatrixStack matrixStackIn, ClientWorld world, Minecraft mc) {
        float celAng;
        VertexBuffer skyVBO = mc.field_71438_f.field_175012_t;
        VertexFormat skyVertexFormat = mc.field_71438_f.field_175014_r;
        RenderSystem.disableTexture();
        Vec3d vec3d = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vec3d.field_72450_a;
        float f1 = (float)vec3d.field_72448_b;
        float f2 = (float)vec3d.field_72449_c;
        float insideVoid = 0.0f;
        if (mc.field_71439_g.func_226278_cu_() <= -2.0) {
            insideVoid = (float)Math.min(1.0, -(mc.field_71439_g.func_226278_cu_() + 2.0) / 30.0);
        }
        f = Math.max(0.0f, f - insideVoid);
        f1 = Math.max(0.0f, f1 - insideVoid);
        f2 = Math.max(0.0f, f2 - insideVoid);
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        skyVBO.func_177359_a();
        skyVertexFormat.func_227892_a_(0L);
        skyVBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        skyVertexFormat.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            int i = 16;
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStackIn.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStackIn.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        this.renderExtra(matrixStackIn, world, partialTicks, insideVoid);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72826_c(partialTicks) * 360.0f));
        Matrix4f matrix4f1 = matrixStackIn.func_227866_c_().func_227870_a_();
        float f12 = 60.0f;
        mc.field_71446_o.func_110577_a(SUN_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 60.0f;
        mc.field_71446_o.func_110577_a(MOON_PHASES_TEXTURES);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, f12).func_225583_a_(f15, f16).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, f12).func_225583_a_(f13, f16).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, -f12).func_225583_a_(f13, f14).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, -f12).func_225583_a_(f15, f14).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float effCelAng = celAng = world.func_72826_c(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float starAlpha = f11 * Math.max(0.1f, effCelAng * 2.0f);
        this.renderStars(skyVertexFormat, matrixStackIn, mc, starAlpha, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStackIn.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderExtra(MatrixStack ms, ClientWorld world, float partialTicks, float insideVoid) {
        float celAng;
        Tessellator tessellator = Tessellator.func_178181_a();
        float rain = 1.0f - world.func_72867_j(partialTicks);
        float effCelAng = celAng = world.func_72826_c(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float scale = 20.0f;
        float lowA = Math.max(0.0f, effCelAng - 0.3f) * rain;
        float a = Math.max(0.1f, lowA);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        ms.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(a * 4.0f * (1.0f - insideVoid)));
        ms.func_227863_a_(new Vector3f(0.5f, 0.5f, 0.0f).func_229187_a_(90.0f));
        block11: for (int p = 0; p < planetTextures.length; ++p) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(planetTextures[p]);
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_227888_a_(mat, -scale, 100.0f, -scale).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, scale, 100.0f, -scale).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, scale, 100.0f, scale).func_225583_a_(1.0f, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, -scale, 100.0f, scale).func_225583_a_(0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            switch (p) {
                case 0: {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(70.0f));
                    scale = 12.0f;
                    continue block11;
                }
                case 1: {
                    ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(120.0f));
                    scale = 15.0f;
                    continue block11;
                }
                case 2: {
                    ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 1.0f).func_229187_a_(80.0f));
                    scale = 25.0f;
                    continue block11;
                }
                case 3: {
                    ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(100.0f));
                    scale = 10.0f;
                    continue block11;
                }
                case 4: {
                    ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.5f).func_229187_a_(-60.0f));
                    scale = 40.0f;
                }
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.func_227865_b_();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureSkybox);
        scale = 20.0f;
        a = lowA;
        ms.func_227860_a_();
        RenderSystem.blendFuncSeparate((int)770, (int)1, (int)1, (int)0);
        ms.func_227861_a_(0.0, -1.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(220.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        int angles = 90;
        float y = 2.0f;
        float y0 = 0.0f;
        float uPer = 0.0027777778f;
        float anglePer = 360.0f / (float)angles;
        double fuzzPer = Math.PI * 10 / (double)angles;
        float rotSpeed = 1.0f;
        float rotSpeedMod = 0.4f;
        block12: for (int p = 0; p < 3; ++p) {
            float baseAngle = rotSpeed * rotSpeedMod * ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.25f * rotSpeed * rotSpeedMod));
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i = 0; i < angles; ++i) {
                int j = i;
                if (i % 2 == 0) {
                    --j;
                }
                float ang = (float)j * anglePer + baseAngle;
                float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * scale;
                float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * scale;
                float yo = (float)Math.sin(fuzzPer * (double)j) * 1.0f;
                float ut = ang * uPer;
                if (i % 2 == 0) {
                    tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
                    tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
                    continue;
                }
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            switch (p) {
                case 0: {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
                    RenderSystem.color4f((float)1.0f, (float)0.4f, (float)0.4f, (float)a);
                    fuzzPer = 43.982297150257104 / (double)angles;
                    rotSpeed = 0.2f;
                    continue block12;
                }
                case 1: {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(50.0f));
                    RenderSystem.color4f((float)0.4f, (float)1.0f, (float)0.7f, (float)a);
                    fuzzPer = Math.PI * 6 / (double)angles;
                    rotSpeed = 2.0f;
                }
            }
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureRainbow);
        scale = 10.0f;
        float effCelAng1 = celAng;
        if (effCelAng1 > 0.25f) {
            effCelAng1 = 1.0f - effCelAng1;
        }
        effCelAng1 = 0.25f - Math.min(0.25f, effCelAng1);
        long time = world.func_72820_D() + 1000L;
        int day = (int)(time / 24000L);
        Random rand = new Random(day * 255);
        float angle1 = rand.nextFloat() * 360.0f;
        float angle2 = rand.nextFloat() * 360.0f;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(effCelAng1 * (1.0f - insideVoid)));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle1));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle2));
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < angles; ++i) {
            int j = i;
            if (i % 2 == 0) {
                --j;
            }
            float ang = (float)j * anglePer;
            float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * scale;
            float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * scale;
            float yo = 0.0f;
            float ut = ang * uPer;
            if (i % 2 == 0) {
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
                continue;
            }
            tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        ms.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - insideVoid));
        GlStateManager.func_227644_a_((int)770, (int)1, (int)1, (int)0);
    }

    private void renderStars(VertexFormat format, MatrixStack ms, Minecraft mc, float alpha, float partialTicks) {
        VertexBuffer starVBO = mc.field_71438_f.field_175013_s;
        float t = ((float)ClientTickHandler.ticksInGame + partialTicks + 2000.0f) * 0.005f;
        ms.func_227860_a_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(t * 3.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.drawVbo(format, ms, starVBO);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(t));
        RenderSystem.color4f((float)0.5f, (float)1.0f, (float)1.0f, (float)alpha);
        this.drawVbo(format, ms, starVBO);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(t * 2.0f));
        RenderSystem.color4f((float)1.0f, (float)0.75f, (float)0.75f, (float)alpha);
        this.drawVbo(format, ms, starVBO);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(t * 3.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        this.drawVbo(format, ms, starVBO);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(t));
        RenderSystem.color4f((float)0.5f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        this.drawVbo(format, ms, starVBO);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(t * 2.0f));
        RenderSystem.color4f((float)1.0f, (float)0.75f, (float)0.75f, (float)(0.25f * alpha));
        this.drawVbo(format, ms, starVBO);
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    private void drawVbo(VertexFormat skyVertexFormat, MatrixStack ms, VertexBuffer vbo) {
        vbo.func_177359_a();
        skyVertexFormat.func_227892_a_(0L);
        vbo.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        skyVertexFormat.func_227895_d_();
    }
}

