/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

public class RenderTileCorporeaIndex
extends TileEntityRenderer<TileCorporeaIndex> {
    private static final RenderType LAYER = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("botania:textures/model/corporea_index.png"));
    private static final float ANGLE = (float)Math.sin(Math.toRadians(45.0));
    private final ModelRenderer ring = new ModelRenderer(64, 32, 0, 0);
    private final ModelRenderer cube;

    public RenderTileCorporeaIndex(TileEntityRendererDispatcher manager) {
        super(manager);
        this.ring.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.cube = new ModelRenderer(64, 32, 32, 0);
        this.cube.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
    }

    public void render(@Nullable TileCorporeaIndex index, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.0, 0.5);
        float translation = index != null ? (float)((Math.cos(((float)index.ticksWithCloseby + (index.hasCloseby ? partialTicks : 0.0f)) / 10.0f) * 0.5 + 0.5) * 0.25) : 0.0f;
        float rotation = index != null ? (float)(index.ticks * 2) + partialTicks : 0.0f;
        IVertexBuilder buffer = buffers.getBuffer(LAYER);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, -1.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        ms.func_227861_a_(0.0, (double)(1.5f + translation / 2.0f), 0.0);
        ms.func_227863_a_(new Quaternion(new Vector3f(ANGLE, 0.0f, ANGLE), 60.0f, true));
        this.ring.func_228308_a_(ms, buffer, light, overlay);
        ms.func_227862_a_(0.875f, 0.875f, 0.875f);
        ms.func_227863_a_(new Quaternion(new Vector3f(ANGLE, 0.0f, ANGLE), 60.0f, true));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        this.ring.func_228308_a_(ms, buffer, light, overlay);
        ms.func_227862_a_(0.875f, 0.875f, 0.875f);
        ms.func_227863_a_(new Quaternion(new Vector3f(ANGLE, 0.0f, ANGLE), 60.0f, true));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        this.cube.func_228308_a_(ms, buffer, light, overlay);
        ms.func_227865_b_();
        if (index != null && index.closeby > 0.0f) {
            float starScale = 0.02f;
            float starRadius = 2.5f * index.closeby + (index.closeby == 1.0f ? 0.0f : (index.hasCloseby ? partialTicks : -partialTicks)) * 0.2f;
            double rads = (double)(((float)index.ticksWithCloseby + partialTicks) * 2.0f) * Math.PI / 180.0;
            double starX = Math.cos(rads) * (double)starRadius;
            double starZ = Math.sin(rads) * (double)starRadius;
            int color = 0xFF00FF;
            int seed = index.func_174877_v().func_177958_n() ^ index.func_174877_v().func_177956_o() ^ index.func_174877_v().func_177952_p();
            ms.func_227861_a_(starX, 0.3, starZ);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.func_227861_a_(-starX * 2.0, 0.0, -starZ * 2.0);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.func_227861_a_(starX, 0.0, starZ);
            rads = -rads;
            starX = Math.cos(rads) * (double)starRadius;
            starZ = Math.sin(rads) * (double)starRadius;
            ms.func_227861_a_(starX, 0.0, starZ);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.func_227861_a_(-starX * 2.0, 0.0, -starZ * 2.0);
            RenderHelper.renderStar(ms, buffers, color, starScale, starScale, starScale, seed);
            ms.func_227861_a_(starX, 0.0, starZ);
        }
        ms.func_227865_b_();
    }
}

